/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import java.util.ArrayList;
import java.util.List;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRightArrow;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.slot.GuiVirtualSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.qio.PacketQIOClearCraftingWindow;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GuiCraftingWindow
extends GuiWindow {
    private final List<GuiVirtualSlot> slots;
    private final byte index;
    private QIOItemViewerContainer container;

    public GuiCraftingWindow(IGuiWrapper gui, int x, int y, QIOItemViewerContainer container, SelectedWindowData windowData) {
        super(gui, x, y, 124, 80, windowData);
        if (windowData.type != SelectedWindowData.WindowType.CRAFTING) {
            throw new IllegalArgumentException("Crafting windows must have a crafting window type");
        }
        if (windowData.extraData >= 3) {
            throw new IllegalArgumentException("Crafting window index is too high");
        }
        this.index = windowData.extraData;
        this.container = container;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        this.slots = new ArrayList<GuiVirtualSlot>();
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                this.slots.add(this.addChild(new GuiVirtualSlot(this, SlotType.NORMAL, gui, this.relativeX + 8 + column * 18, this.relativeY + 18 + row * 18, this.container.getCraftingWindowSlot(this.index, row * 3 + column))));
            }
        }
        this.addChild((GuiRightArrow)new GuiRightArrow(gui, this.relativeX + 70, this.relativeY + 38).recipeViewerCrafting());
        this.slots.add(this.addChild(new GuiVirtualSlot(this, SlotType.NORMAL, gui, this.relativeX + 100, this.relativeY + 36, this.container.getCraftingWindowSlot(this.index, 9))));
        this.addChild(new MekanismImageButton(gui, this.relativeX + this.width - 20, this.relativeY + this.height - 20, 14, GuiCraftingWindow.getButtonLocation("clear_sides"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketQIOClearCraftingWindow(this.index, Screen.hasShiftDown())))).setTooltip(MekanismLang.CRAFTING_WINDOW_CLEAR);
    }

    public void updateContainer(QIOItemViewerContainer container) {
        this.container = container;
        for (int i = 0; i < this.slots.size(); ++i) {
            this.slots.get(i).updateVirtualSlot(this, this.container.getCraftingWindowSlot(this.index, i));
        }
    }

    public byte getIndex() {
        return this.index;
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MekanismLang.CRAFTING_WINDOW.translate(this.index + 1), 6);
    }
}

