/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@ParametersAreNotNullByDefault
public record ModuleAttackAmplificationUnit(AttackDamage attackDamage) implements ICustomModule<ModuleAttackAmplificationUnit>
{
    public static final ResourceLocation ATTACK_DAMAGE = Mekanism.rl("bonus_attack_damage");

    public ModuleAttackAmplificationUnit(IModule<ModuleAttackAmplificationUnit> module) {
        this((AttackDamage)module.getConfigOrThrow(ATTACK_DAMAGE).get());
    }

    public int getDamage() {
        return this.attackDamage.getDamage();
    }

    @Override
    public void addHUDStrings(IModule<ModuleAttackAmplificationUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player, Consumer<Component> hudStringAdder) {
        if (module.isEnabled()) {
            hudStringAdder.accept((Component)MekanismLang.MODULE_DAMAGE.translateColored(EnumColor.DARK_GRAY, EnumColor.INDIGO, this.getDamage()));
        }
    }

    @NothingNullByDefault
    public static enum AttackDamage implements IHasTextComponent,
    StringRepresentable
    {
        OFF(0),
        LOW(4),
        MED(8),
        HIGH(16),
        EXTREME(24),
        MAX(32);

        public static final Codec<AttackDamage> CODEC;
        public static final IntFunction<AttackDamage> BY_ID;
        public static final StreamCodec<ByteBuf, AttackDamage> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final int damage;
        private final Component label;

        private AttackDamage(int damage) {
            this.damage = damage;
            this.label = TextComponentUtil.getString(Integer.toString(damage));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public int getDamage() {
            return this.damage;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(AttackDamage::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])AttackDamage.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

