/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import mekanism.api.SerializerHelper;
import mekanism.api.math.MathUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class EnergyElement
extends LookingAtElement {
    public static final MapCodec<EnergyElement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("energy").forGetter(EnergyElement::getEnergy), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("max").forGetter(EnergyElement::getMaxEnergy)).apply((Applicative)instance, EnergyElement::new));
    public static final StreamCodec<ByteBuf, EnergyElement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, EnergyElement::getEnergy, (StreamCodec)ByteBufCodecs.VAR_LONG, EnergyElement::getMaxEnergy, EnergyElement::new);
    protected final long energy;
    protected final long maxEnergy;

    public EnergyElement(long energy, long maxEnergy) {
        super(-16777216, 0xFFFFFF);
        this.energy = energy;
        this.maxEnergy = maxEnergy;
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.energy == Long.MAX_VALUE) {
            return level;
        }
        return (int)((double)level * MathUtils.divideToLevel(this.energy, this.maxEnergy));
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return MekanismRenderer.energyIcon;
    }

    @Override
    public Component getText() {
        return EnergyDisplay.of(this.energy, this.maxEnergy).getTextComponent();
    }

    @Override
    public ResourceLocation getID() {
        return LookingAtUtils.ENERGY;
    }
}

