/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilterTransformIterator<IN, OUT>
implements Iterator<OUT> {
    private final Iterator<IN> iterator;
    private OUT next;

    protected FilterTransformIterator(Iterator<@NotNull IN> upstream) {
        this.iterator = upstream;
        this.next = this.findNext();
    }

    @Nullable
    private OUT findNext() {
        while (this.iterator.hasNext()) {
            OUT potentialNext = this.filterTransform(this.iterator.next());
            if (potentialNext == null) continue;
            return potentialNext;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public OUT next() {
        if (this.next != null) {
            OUT thisNext = this.next;
            this.next = this.findNext();
            return thisNext;
        }
        throw new NoSuchElementException();
    }

    @Nullable
    protected abstract OUT filterTransform(IN var1);
}

