/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radial.data;

import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.radial.ClassBasedRadialData;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class TruncatedEnumRadialData<MODE extends Enum<MODE>>
extends ClassBasedRadialData<MODE> {
    private final List<MODE> modes;
    private final MODE defaultMode;

    TruncatedEnumRadialData(ResourceLocation identifier, int accessibleValues, MODE defaultMode) {
        super(identifier, ((Enum)Objects.requireNonNull(defaultMode, "Default mode cannot be null.")).getDeclaringClass());
        if (accessibleValues <= 0) {
            throw new IllegalArgumentException("Invalid accessibleValues, there must be at least one mode that is accessible.");
        }
        this.defaultMode = defaultMode;
        Enum[] constants = (Enum[])this.clazz.getEnumConstants();
        if (constants.length < accessibleValues) {
            throw new IllegalArgumentException("There are more accessible values than the number of elements in " + this.clazz.getSimpleName());
        }
        if (constants.length == accessibleValues) {
            this.modes = List.of(constants);
        } else {
            if (((Enum)this.defaultMode).ordinal() >= accessibleValues) {
                throw new IllegalArgumentException("Invalid default, it is out of range of the accessible values.");
            }
            this.modes = List.of(constants).subList(0, accessibleValues);
        }
    }

    @Override
    public MODE getDefaultMode(List<MODE> modes) {
        return this.defaultMode;
    }

    @Override
    public List<MODE> getModes() {
        return this.modes;
    }

    @Override
    public int index(List<MODE> modes, MODE mode) {
        return this.getNetworkRepresentation(mode);
    }

    @Override
    public int getNetworkRepresentation(MODE mode) {
        int networkRepresentation = ((Enum)mode).ordinal();
        if (networkRepresentation >= this.modes.size()) {
            return -1;
        }
        return networkRepresentation;
    }

    @Override
    @Nullable
    public MODE fromNetworkRepresentation(int networkRepresentation) {
        if (networkRepresentation >= 0 && networkRepresentation < this.modes.size()) {
            return (MODE)((Enum)this.modes.get(networkRepresentation));
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass() || !super.equals(other)) {
            return false;
        }
        return this.modes.size() == ((TruncatedEnumRadialData)other).modes.size();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.modes.size();
        return result;
    }
}

