/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionCategoryContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionPageContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BookUnlockStates {
    public static final Codec<BookUnlockStates> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, Codecs.set(ResourceLocation.CODEC)).fieldOf("readEntries").forGetter(s -> s.readEntries), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.unboundedMap((Codec)ResourceLocation.CODEC, Codecs.set(Codec.INT))).fieldOf("unlockedPages").forGetter(s -> s.unlockedPages), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, Codecs.set(ResourceLocation.CODEC)).fieldOf("unlockedEntries").forGetter(s -> s.unlockedEntries), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, Codecs.set(ResourceLocation.CODEC)).fieldOf("unlockedCategories").forGetter(s -> s.unlockedCategories), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT)).fieldOf("usedCommands").forGetter(s -> s.usedCommands)).apply((Applicative)instance, BookUnlockStates::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BookUnlockStates> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    public Map<ResourceLocation, Set<ResourceLocation>> readEntries;
    public Map<ResourceLocation, Map<ResourceLocation, Set<Integer>>> unlockedPages;
    public Map<ResourceLocation, Set<ResourceLocation>> unlockedEntries;
    public Map<ResourceLocation, Set<ResourceLocation>> unlockedCategories;
    public Map<ResourceLocation, Map<ResourceLocation, Integer>> usedCommands;

    public BookUnlockStates() {
        this((Map<ResourceLocation, Set<ResourceLocation>>)Object2ObjectMaps.emptyMap(), (Map<ResourceLocation, Map<ResourceLocation, Set<Integer>>>)Object2ObjectMaps.emptyMap(), (Map<ResourceLocation, Set<ResourceLocation>>)Object2ObjectMaps.emptyMap(), (Map<ResourceLocation, Set<ResourceLocation>>)Object2ObjectMaps.emptyMap(), (Map<ResourceLocation, Map<ResourceLocation, Integer>>)Object2ObjectMaps.emptyMap());
    }

    public BookUnlockStates(Map<ResourceLocation, Set<ResourceLocation>> readEntries, Map<ResourceLocation, Map<ResourceLocation, Set<Integer>>> unlockedPages, Map<ResourceLocation, Set<ResourceLocation>> unlockedEntries, Map<ResourceLocation, Set<ResourceLocation>> unlockedCategories, Map<ResourceLocation, Map<ResourceLocation, Integer>> usedCommands) {
        this.readEntries = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap(readEntries));
        this.unlockedPages = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        unlockedPages.forEach((bookId, entryPagesMap) -> {
            Map innerMap = this.unlockedPages.computeIfAbsent((ResourceLocation)bookId, k -> Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap()));
            entryPagesMap.forEach((entryId, pages) -> innerMap.put(entryId, new ObjectOpenHashSet((Collection)pages)));
        });
        this.unlockedEntries = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        unlockedEntries.forEach((bookId, entries) -> this.unlockedEntries.put((ResourceLocation)bookId, (Set<ResourceLocation>)new ObjectOpenHashSet((Collection)entries)));
        this.unlockedCategories = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        unlockedCategories.forEach((bookId, categories) -> this.unlockedCategories.put((ResourceLocation)bookId, (Set<ResourceLocation>)new ObjectOpenHashSet((Collection)categories)));
        this.usedCommands = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        usedCommands.forEach((bookId, commandUsesMap) -> {
            Map innerMap = this.usedCommands.computeIfAbsent((ResourceLocation)bookId, k -> Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap()));
            innerMap.putAll(commandUsesMap);
        });
    }

    public void update(ServerPlayer owner) {
        ArrayList<Map.Entry<BookCondition, BookConditionContext>> conditionsThatRequireMultipass = new ArrayList<Map.Entry<BookCondition, BookConditionContext>>();
        for (Book book : BookDataManager.get().getBooks().values()) {
            BookErrorManager.get().reset();
            BookErrorManager.get().setCurrentBookId(book.getId());
            for (BookCategory category : book.getCategories().values()) {
                BookErrorManager.get().setContext("Category to perform condition test on: {}", category.getId().toString());
                try {
                    BookConditionContext categoryContext = BookConditionContext.of(book, category);
                    if (category.getCondition().test(categoryContext, (Player)owner)) {
                        this.unlockedCategories.computeIfAbsent(book.getId(), k -> new ObjectOpenHashSet()).add(category.getId());
                    } else if (category.getCondition().requiresMultiPassUnlockTest()) {
                        conditionsThatRequireMultipass.add(Map.entry(category.getCondition(), categoryContext));
                    }
                }
                catch (Exception e) {
                    BookErrorManager.get().error("Error while testing category condition", e);
                }
                for (BookEntry entry : category.getEntries().values()) {
                    BookErrorManager.get().setContext("Entry to perform condition test on: {}", entry.getId().toString());
                    try {
                        BookConditionContext entryContext = BookConditionContext.of(book, entry);
                        if (entry.getCondition().test(entryContext, (Player)owner)) {
                            this.unlockedEntries.computeIfAbsent(book.getId(), k -> new ObjectOpenHashSet()).add(entry.getId());
                        } else if (entry.getCondition().requiresMultiPassUnlockTest()) {
                            conditionsThatRequireMultipass.add(Map.entry(entry.getCondition(), entryContext));
                        }
                    }
                    catch (Exception e) {
                        BookErrorManager.get().error("Error while testing entry condition", e);
                    }
                    for (BookPage page : entry.getPages()) {
                        BookErrorManager.get().setContext("Page to perform condition test on: {}", page.getPageNumber());
                        try {
                            BookConditionContext pageContext = BookConditionContext.of(book, page);
                            BookCondition pageCondition = page.getCondition();
                            if (pageCondition.test(pageContext, (Player)owner)) {
                                Set pages = this.unlockedPages.computeIfAbsent(book.getId(), k -> new Object2ObjectOpenHashMap()).computeIfAbsent(entry.getId(), k -> new ObjectOpenHashSet());
                                if (pages.contains(page.getPageNumber())) continue;
                                pages.add(page.getPageNumber());
                                this.readEntries.computeIfAbsent(book.getId(), k -> new ObjectOpenHashSet()).remove(entry.getId());
                                continue;
                            }
                            if (!pageCondition.requiresMultiPassUnlockTest()) continue;
                            conditionsThatRequireMultipass.add(Map.entry(pageCondition, pageContext));
                        }
                        catch (Exception e) {
                            BookErrorManager.get().error("Error while testing page condition", e);
                        }
                    }
                }
            }
        }
        BookErrorManager.get().reset();
        boolean unlockedAny = false;
        do {
            unlockedAny = false;
            Iterator iter = conditionsThatRequireMultipass.iterator();
            while (iter.hasNext()) {
                Map.Entry condition = (Map.Entry)iter.next();
                BookErrorManager.get().setCurrentBookId(((BookConditionContext)condition.getValue()).getBook().getId());
                BookErrorManager.get().setContext("Context to perform unlockedConditions test on: {}", ((BookConditionContext)condition.getValue()).toString());
                if (!((BookCondition)condition.getKey()).test((BookConditionContext)condition.getValue(), (Player)owner)) continue;
                try {
                    Object e = condition.getValue();
                    if (e instanceof BookConditionPageContext) {
                        BookConditionPageContext pageContext = (BookConditionPageContext)e;
                        Set pages = this.unlockedPages.computeIfAbsent(pageContext.getBook().getId(), k -> new Object2ObjectOpenHashMap()).computeIfAbsent(pageContext.getEntry().getId(), k -> new ObjectOpenHashSet());
                        if (!pages.contains(pageContext.getPage().getPageNumber())) {
                            pages.add(pageContext.getPage().getPageNumber());
                            this.readEntries.computeIfAbsent(pageContext.getBook().getId(), k -> new ObjectOpenHashSet()).remove(pageContext.getEntry().getId());
                        }
                    } else {
                        Object v = condition.getValue();
                        if (v instanceof BookConditionEntryContext) {
                            BookConditionEntryContext entryContext = (BookConditionEntryContext)v;
                            this.unlockedEntries.computeIfAbsent(entryContext.getBook().getId(), k -> new ObjectOpenHashSet()).add(entryContext.getEntry().getId());
                        } else {
                            v = condition.getValue();
                            if (v instanceof BookConditionCategoryContext) {
                                BookConditionCategoryContext categoryContext = (BookConditionCategoryContext)v;
                                this.unlockedCategories.computeIfAbsent(categoryContext.getBook().getId(), k -> new ObjectOpenHashSet()).add(categoryContext.getCategory().getId());
                            }
                        }
                    }
                    unlockedAny = true;
                    iter.remove();
                }
                catch (Exception e) {
                    BookErrorManager.get().error("Error while testing condition", e);
                }
            }
        } while (unlockedAny);
        BookErrorManager.get().reset();
    }

    public boolean read(BookEntry entry, ServerPlayer player) {
        if (this.isRead(entry)) {
            return false;
        }
        this.readEntries.computeIfAbsent(entry.getBook().getId(), k -> new ObjectOpenHashSet()).add(entry.getId());
        BookCommand command = entry.getCommandToRunOnFirstRead();
        if (command != null) {
            command.execute(player);
        }
        return true;
    }

    public void setRun(BookCommand command) {
        if (command.getBook() == null) {
            return;
        }
        Integer uses = this.usedCommands.getOrDefault(command.getBook().getId(), (Map<ResourceLocation, Integer>)new Object2ObjectOpenHashMap()).getOrDefault(command.getId(), 0);
        this.usedCommands.computeIfAbsent(command.getBook().getId(), k -> new Object2ObjectOpenHashMap()).put(command.getId(), uses + 1);
    }

    public boolean canRun(BookCommand command) {
        if (command.getBook() == null) {
            return false;
        }
        if (command.getMaxUses() == -1) {
            return true;
        }
        return this.usedCommands.getOrDefault(command.getBook().getId(), (Map<ResourceLocation, Integer>)new Object2ObjectOpenHashMap()).getOrDefault(command.getId(), 0) < command.getMaxUses();
    }

    public boolean isRead(BookEntry entry) {
        if (entry.getBook() == null) {
            return false;
        }
        return this.readEntries.getOrDefault(entry.getBook().getId(), (Set<ResourceLocation>)new ObjectOpenHashSet()).contains(entry.getId());
    }

    public List<BookPage> getUnlockedPagesIn(BookEntry entry) {
        Set<Integer> unlockedPageNumbers = this.unlockedPages.getOrDefault(entry.getBook().getId(), (Map<ResourceLocation, Set<Integer>>)new Object2ObjectOpenHashMap()).getOrDefault(entry.getId(), (Set<Integer>)new ObjectOpenHashSet());
        return entry.getPages().stream().filter(page -> unlockedPageNumbers.contains(page.getPageNumber())).toList();
    }

    public boolean isUnlocked(BookPage page) {
        if (page.getBook() == null) {
            return false;
        }
        return this.unlockedPages.getOrDefault(page.getBook().getId(), (Map<ResourceLocation, Set<Integer>>)new Object2ObjectOpenHashMap()).getOrDefault(page.getParentEntry().getId(), (Set<Integer>)new ObjectOpenHashSet()).contains(page.getPageNumber());
    }

    public boolean isUnlocked(BookEntry entry) {
        if (entry.getBook() == null) {
            return false;
        }
        return this.unlockedEntries.getOrDefault(entry.getBook().getId(), (Set<ResourceLocation>)new ObjectOpenHashSet()).contains(entry.getId());
    }

    public boolean isUnlocked(BookCategory category) {
        if (category.getBook() == null) {
            return false;
        }
        return this.unlockedCategories.getOrDefault(category.getBook().getId(), (Set<ResourceLocation>)new ObjectOpenHashSet()).contains(category.getId());
    }

    public void reset(Book book) {
        this.readEntries.remove(book.getId());
        this.unlockedPages.remove(book.getId());
        this.unlockedEntries.remove(book.getId());
        this.unlockedCategories.remove(book.getId());
    }

    public List<ResourceLocation> getBooks() {
        ObjectOpenHashSet books = new ObjectOpenHashSet();
        books.addAll(this.readEntries.keySet());
        books.addAll(this.unlockedPages.keySet());
        books.addAll(this.unlockedEntries.keySet());
        books.addAll(this.unlockedCategories.keySet());
        return books.stream().toList();
    }

    public String getUnlockCode(Book book) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeResourceLocation(book.getId());
        Set unlockedCategories = this.unlockedCategories.getOrDefault(book.getId(), Set.of());
        buf.writeVarInt(unlockedCategories.size());
        unlockedCategories.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeResourceLocation(arg_0));
        Set unlockedEntries = this.unlockedEntries.getOrDefault(book.getId(), Set.of());
        buf.writeVarInt(unlockedEntries.size());
        unlockedEntries.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeResourceLocation(arg_0));
        Map<ResourceLocation, Set> unlockedPages = this.unlockedPages.getOrDefault(book.getId(), Map.of());
        buf.writeVarInt(unlockedPages.size());
        unlockedPages.forEach((entry, pages) -> {
            buf.writeResourceLocation(entry);
            buf.writeVarInt(pages.size());
            pages.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeVarInt(arg_0));
        });
        Set readEntries = this.readEntries.getOrDefault(book.getId(), Set.of());
        buf.writeVarInt(readEntries.size());
        readEntries.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeResourceLocation(arg_0));
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public Book applyUnlockCode(String code) {
        try {
            byte[] decoded = Base64.getDecoder().decode(code);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])decoded));
            ResourceLocation bookId = buf.readResourceLocation();
            Book book = BookDataManager.get().getBook(bookId);
            if (book == null) {
                return null;
            }
            ObjectOpenHashSet unlockedCategories = new ObjectOpenHashSet();
            ObjectOpenHashSet unlockedEntries = new ObjectOpenHashSet();
            Object2ObjectOpenHashMap unlockedPages = new Object2ObjectOpenHashMap();
            ObjectOpenHashSet readEntries = new ObjectOpenHashSet();
            int unlockedCategoriesSize = buf.readVarInt();
            for (int i = 0; i < unlockedCategoriesSize; ++i) {
                unlockedCategories.add((Object)buf.readResourceLocation());
            }
            int unlockedEntriesSize = buf.readVarInt();
            for (int i = 0; i < unlockedEntriesSize; ++i) {
                unlockedEntries.add((Object)buf.readResourceLocation());
            }
            int unlockedPagesSize = buf.readVarInt();
            for (int i = 0; i < unlockedPagesSize; ++i) {
                ResourceLocation entryId = buf.readResourceLocation();
                ObjectOpenHashSet unlockedPagesForEntry = new ObjectOpenHashSet();
                unlockedPages.put((Object)entryId, (Object)unlockedPagesForEntry);
                int pagesSize = buf.readVarInt();
                for (int j = 0; j < pagesSize; ++j) {
                    unlockedPagesForEntry.add((Object)buf.readVarInt());
                }
            }
            int readEntriesSize = buf.readVarInt();
            for (int i = 0; i < readEntriesSize; ++i) {
                readEntries.add((Object)buf.readResourceLocation());
            }
            unlockedCategories.trim();
            unlockedPages.trim();
            unlockedPages.trim();
            readEntries.trim();
            this.unlockedCategories.put(bookId, (Set<ResourceLocation>)unlockedCategories);
            this.unlockedEntries.put(bookId, (Set<ResourceLocation>)unlockedEntries);
            this.unlockedPages.put(bookId, (Map<ResourceLocation, Set<Integer>>)unlockedPages);
            this.readEntries.put(bookId, (Set<ResourceLocation>)readEntries);
            return book;
        }
        catch (Exception e) {
            return null;
        }
    }
}

