/*
 * Decompiled with CFR 0.152.
 */
package de.kb1000.notelemetry;

import de.kb1000.notelemetry.NoTelemetryAbstractMixinConfigPlugin;
import de.kb1000.notelemetry.NoTelemetryFabricMixinConfigPlugin;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class NoTelemetryForgeMixinConfigPlugin
extends NoTelemetryAbstractMixinConfigPlugin {
    private boolean isForgeNeo = false;

    @Override
    public void onLoad(String mixinPackage) {
        this.isForgeNeo = NoTelemetryForgeMixinConfigPlugin.isForgeNeo();
    }

    @Override
    public String getRefMapperConfig() {
        if (this.isForgeNeo) {
            return null;
        }
        if (this.minecraftNewerThan("1.21")) {
            return "no-telemetry-mojank-refmap.json";
        }
        if (this.minecraftNewerThan("1.20.5")) {
            return "no-telemetry-mojank-1.20-refmap.json";
        }
        return "no-telemetry-forge-refmap.json";
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (this.isForgeNeo) {
            return false;
        }
        return !this.isForgeNeo && super.shouldApplyMixin(targetClassName, mixinClassName);
    }

    @Override
    protected boolean minecraftNewerThan(String version) {
        try {
            return VersionRange.createFromVersionSpec((String)("[" + version + ",)")).containsVersion((ArtifactVersion)new DefaultArtifactVersion(FMLLoader.versionInfo().mcVersion()));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isForgeNeo() {
        try {
            return NoTelemetryFabricMixinConfigPlugin.class.getClassLoader().loadClass("net.neoforged.fml.common.Mod") != null;
        }
        catch (Exception | LinkageError e) {
            return false;
        }
    }
}

