/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed;

import dev.dhyces.trimmed.TrimmedClient;
import java.util.Set;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterSpriteSourceTypesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@Mod(value="trimmed", dist={Dist.CLIENT})
public class NeoTrimmedClient {
    private static Set<ResourceLocation> additionalGeneratedModels;

    public NeoTrimmedClient(IEventBus modBus, ModContainer container) {
        TrimmedClient.init();
        modBus.addListener(this::registerSpriteSourceTypes);
        modBus.addListener(this::registerClientReloadListener);
        modBus.addListener(this::addModels);
        NeoForge.EVENT_BUS.addListener(this::tagsSynced);
        NeoForge.EVENT_BUS.addListener(this::onShutdown);
        NeoForge.EVENT_BUS.addListener(this::onLogout);
        TrimmedClient.initApi();
    }

    private void registerSpriteSourceTypes(RegisterSpriteSourceTypesEvent event) {
        TrimmedClient.registerSpriteSourceTypes((arg_0, arg_1) -> ((RegisterSpriteSourceTypesEvent)event).register(arg_0, arg_1));
    }

    private void registerClientReloadListener(RegisterClientReloadListenersEvent event) {
        TrimmedClient.registerClientReloadListener((s, preparableReloadListener) -> event.registerReloadListener(preparableReloadListener));
        TrimmedClient.injectListenersAtBeginning();
    }

    private void addModels(ModelEvent.RegisterAdditional event) {
        additionalGeneratedModels.forEach(resourceId -> event.register(ModelResourceLocation.standalone((ResourceLocation)resourceId)));
    }

    private void tagsSynced(TagsUpdatedEvent event) {
        TrimmedClient.onTagsSynced(event.getRegistryAccess(), event.shouldUpdateStaticData());
    }

    private void onShutdown(ServerStoppingEvent event) {
        TrimmedClient.resetSyncedStatus();
    }

    private void onLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        TrimmedClient.resetSyncedStatus();
    }

    public static void setModels(Set<ResourceLocation> models) {
        additionalGeneratedModels = models;
    }
}

