/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface KeyResolver<T> {
    @Nullable
    public T decode(ResourceLocation var1, DynamicOps<?> var2);

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, T> getStreamCodec();

    public boolean requiresActiveWorld();

    public record Static<T>(Registry<T> registry) implements RegistryResolver<T>
    {
        @Override
        public ResourceKey<? extends Registry<T>> getKey() {
            return this.registry.key();
        }

        @Override
        @Nullable
        public T decode(ResourceLocation resourceLocation, DynamicOps<?> ops) {
            return (T)this.registry.get(resourceLocation);
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, T> getStreamCodec() {
            return ByteBufCodecs.registry((ResourceKey)this.registry.key());
        }

        @Override
        public boolean requiresActiveWorld() {
            return false;
        }
    }

    public record Dynamic<T>(ResourceKey<? extends Registry<T>> registryKey) implements RegistryResolver<T>
    {
        @Override
        public ResourceKey<? extends Registry<T>> getKey() {
            return this.registryKey;
        }

        @Override
        @Nullable
        public T decode(ResourceLocation resourceLocation, DynamicOps<?> ops) {
            if (!(ops instanceof RegistryOps)) {
                throw new IllegalArgumentException("Must have registry ops to decode dynamic content.");
            }
            RegistryOps registryOps = (RegistryOps)ops;
            return ((HolderGetter)registryOps.getter(this.registryKey).orElseThrow(() -> new IllegalStateException("Registry {%s} is not available".formatted(this.registryKey.location())))).get(ResourceKey.create(this.registryKey, (ResourceLocation)resourceLocation)).map(Holder.Reference::value).orElse(null);
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, T> getStreamCodec() {
            return ByteBufCodecs.registry(this.registryKey);
        }

        @Override
        public boolean requiresActiveWorld() {
            return true;
        }
    }

    public static interface RegistryResolver<T>
    extends KeyResolver<T> {
        public ResourceKey<? extends Registry<T>> getKey();
    }
}

