/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.client.tag.appenders;

import dev.dhyces.trimmed.api.data.client.tag.appenders.ClientTagAppender;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface MappedTagExtension<T, S extends ClientTagAppender<T>> {
    public Function<T, @Nullable ResourceLocation> getEncoder();

    public S getSelf();

    default public S add(T element) {
        ResourceLocation encoded = this.getEncoder().apply(element);
        if (encoded == null) {
            throw new IllegalArgumentException("Encoder could not map key to resource location");
        }
        ((ClientTagAppender)this.getSelf()).add(encoded);
        return this.getSelf();
    }

    default public S add(T ... elements) {
        for (T element : elements) {
            ResourceLocation encoded = this.getEncoder().apply(element);
            if (encoded == null) {
                throw new IllegalArgumentException("Encoder could not map key to resource location");
            }
            ((ClientTagAppender)this.getSelf()).add(encoded);
        }
        return this.getSelf();
    }

    default public S addOptional(T element) {
        ResourceLocation encoded = this.getEncoder().apply(element);
        if (encoded == null) {
            throw new IllegalArgumentException("Encoder could not map key to resource location");
        }
        ((ClientTagAppender)this.getSelf()).addOptional(encoded);
        return this.getSelf();
    }

    default public S addOptional(T ... elements) {
        for (T element : elements) {
            ResourceLocation encoded = this.getEncoder().apply(element);
            if (encoded == null) {
                throw new IllegalArgumentException("Encoder could not map key to resource location");
            }
            ((ClientTagAppender)this.getSelf()).addOptional(encoded);
        }
        return this.getSelf();
    }
}

