/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.map;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dhyces.trimmed.api.client.TrimmedClientApi;
import dev.dhyces.trimmed.api.data.map.MapBuilder;
import dev.dhyces.trimmed.api.data.map.MapFile;
import dev.dhyces.trimmed.api.data.map.NeoClientMapDataProvider;
import dev.dhyces.trimmed.api.data.map.appenders.MapAppender;
import dev.dhyces.trimmed.api.data.map.appenders.MappedMapAppender;
import dev.dhyces.trimmed.api.maps.MapKey;
import dev.dhyces.trimmed.api.util.Utils;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class ClientMapDataProvider<K>
extends NeoClientMapDataProvider<K> {
    public ClientMapDataProvider(PackOutput packOutput, String modid, ExistingFileHelper existingFileHelper) {
        super(packOutput, modid, existingFileHelper);
    }

    public <V> MapAppender<K, V> map(MapKey<K, V> mapKey) {
        return new MapAppender(this.getOrCreateBuilder(mapKey));
    }

    public <V> MapAppender<K, V> map(MapKey<K, V> mapKey, Function<K, @Nullable ResourceLocation> encoder) {
        return new MappedMapAppender<K, V>(this.getOrCreateBuilder(mapKey), encoder);
    }

    protected abstract void addMaps();

    public CompletableFuture<?> run(CachedOutput pOutput) {
        this.addMaps();
        this.complete();
        return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map((? super T entry) -> {
            Codec codec = MapFile.codec(((MapKey)entry.getKey()).getType().getValueCodec());
            DataResult elementResult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((MapFile)Utils.unsafeCast(((MapBuilder)entry.getValue()).build())));
            Path path = this.pathProvider.json(((MapKey)entry.getKey()).compilePathAndIdNamespace().withPrefix(Utils.namespacedPath(TrimmedClientApi.getInstance().getId(((MapKey)entry.getKey()).getType().getKeyResolver())) + "/"));
            return DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)((JsonElement)elementResult.getOrThrow()), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "ClientMapDataProvider for " + this.modid;
    }
}

