/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.map;

import com.mojang.serialization.Codec;
import dev.dhyces.trimmed.api.data.map.MapBuilder;
import dev.dhyces.trimmed.api.data.map.MapFile;
import dev.dhyces.trimmed.api.data.map.NeoClientMapDataProvider;
import dev.dhyces.trimmed.api.data.map.appenders.RegistryMapAppender;
import dev.dhyces.trimmed.api.maps.MapKey;
import dev.dhyces.trimmed.api.util.Utils;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class ClientRegistryMapDataProvider<K>
extends NeoClientMapDataProvider<K> {
    protected final ResourceKey<? extends Registry<K>> registryKey;
    protected final CompletableFuture<HolderLookup.Provider> lookupProviderFuture;

    public ClientRegistryMapDataProvider(PackOutput packOutput, String modid, ResourceKey<? extends Registry<K>> registryKey, CompletableFuture<HolderLookup.Provider> lookupProviderFuture, ExistingFileHelper existingFileHelper) {
        super(packOutput, modid, existingFileHelper);
        this.registryKey = registryKey;
        this.lookupProviderFuture = lookupProviderFuture;
    }

    public <V> RegistryMapAppender<K, V> map(MapKey<K, V> mapKey, HolderLookup.Provider lookupProvider) {
        return new RegistryMapAppender(this.getOrCreateBuilder(mapKey), lookupProvider.lookupOrThrow(this.registryKey));
    }

    public <V> RegistryMapAppender.Mapped<K, V> map(MapKey<K, V> mapKey, HolderLookup.Provider lookupProvider, Function<K, @Nullable ResourceLocation> encoder) {
        return new RegistryMapAppender.Mapped<K, V>(this.getOrCreateBuilder(mapKey), lookupProvider.lookupOrThrow(this.registryKey), encoder);
    }

    protected abstract void addMaps(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return ((CompletableFuture)this.lookupProviderFuture.thenApply(provider -> {
            this.addMaps((HolderLookup.Provider)provider);
            this.complete();
            return provider;
        })).thenCompose(provider -> {
            HolderLookup.RegistryLookup registryLookup = provider.lookupOrThrow(this.registryKey);
            return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(entry -> {
                if (this.exists(registryLookup, ResourceKey.create(this.registryKey, (ResourceLocation)((MapKey)entry.getKey()).getMapId()))) {
                    throw new IllegalStateException("Element %s does not exist in %s".formatted(entry.getKey(), this.registryKey));
                }
                Codec codec = MapFile.codec(((MapKey)entry.getKey()).getType().getValueCodec());
                Path path = this.pathProvider.json(((MapKey)entry.getKey()).compilePathAndIdNamespace().withPrefix(Utils.namespacedLocation(this.registryKey) + "/"));
                return DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)provider, codec, (Object)((MapFile)Utils.unsafeCast(((MapBuilder)entry.getValue()).build())), (Path)path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected boolean exists(HolderLookup.RegistryLookup<K> firstLookup, ResourceKey<K> resourceKey) {
        return firstLookup.get(resourceKey).isPresent();
    }

    public String getName() {
        return "ClientRegistryMapDataProvider<" + String.valueOf(this.registryKey.location()) + "> for " + this.modid;
    }
}

