/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.map.appenders;

import dev.dhyces.trimmed.api.data.map.MapBuilder;
import dev.dhyces.trimmed.api.maps.MapKey;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class MapAppender<K, V> {
    protected final MapBuilder<V> builder;

    protected <S extends MapAppender<K, V>> S self() {
        return (S)this;
    }

    public MapAppender(MapBuilder<V> builder) {
        this.builder = builder;
    }

    public <S extends MapAppender<K, V>> S put(ResourceLocation key, V value) {
        this.builder.addEntry(key, value);
        return this.self();
    }

    public <S extends MapAppender<K, V>> S putOptional(ResourceLocation key, V value) {
        this.builder.addOptionalEntry(key, value);
        return this.self();
    }

    public <S extends MapAppender<K, V>> S putAll(Map<ResourceLocation, V> map) {
        map.forEach(this.builder::addEntry);
        return this.self();
    }

    public <S extends MapAppender<K, V>> S putAllOptional(Map<ResourceLocation, V> map) {
        map.forEach(this.builder::addOptionalEntry);
        return this.self();
    }

    public <S extends MapAppender<K, V>> S append(ResourceLocation clientMapKey) {
        this.builder.append(clientMapKey);
        return this.self();
    }

    public <S extends MapAppender<K, V>> S append(MapKey<K, V> mapKey) {
        this.builder.append(mapKey.getMapId());
        return this.self();
    }

    public <S extends MapAppender<K, V>> S appendOptional(ResourceLocation clientMapKey) {
        this.builder.appendOptional(clientMapKey);
        return this.self();
    }

    public <S extends MapAppender<K, V>> S appendOptional(MapKey<K, V> mapKey) {
        this.builder.appendOptional(mapKey.getMapId());
        return this.self();
    }

    public <S extends MapAppender<K, V>> S replaces() {
        this.builder.replaces();
        return this.self();
    }
}

