/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.model.source;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.api.client.TrimmedClientMapApi;
import dev.dhyces.trimmed.api.client.map.ClientMapKeys;
import dev.dhyces.trimmed.api.client.map.ClientMapTypes;
import dev.dhyces.trimmed.api.maps.MapKey;
import dev.dhyces.trimmed.impl.client.models.source.ModelSource;
import dev.dhyces.trimmed.impl.client.models.source.ModelSourceRegistry;
import dev.dhyces.trimmed.impl.client.models.source.TrimModelSource;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;

public abstract class BaseModelSourceDataProvider
implements DataProvider {
    private static final ResourceLocation TWO_LAYER_TEMPLATE = Trimmed.id("item/two_layer_trim");
    private static final ResourceLocation THREE_LAYER_TEMPLATE = Trimmed.id("item/three_layer_trim");
    protected final PackOutput packOutput;
    protected final PackOutput.PathProvider pathProvider;
    protected final String modid;
    protected final Map<ResourceLocation, ModelSource> modelSources;

    public BaseModelSourceDataProvider(PackOutput packOutput, String modid) {
        this.packOutput = packOutput;
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "trimmed/model_generators");
        this.modid = modid;
        this.modelSources = new Object2ObjectLinkedOpenHashMap();
    }

    protected abstract void addModelSources();

    public void addTwoLayerTrimsSource(ArmorMaterial armorMaterial) {
        ResourceLocation materialId = ((ResourceKey)BuiltInRegistries.ARMOR_MATERIAL.getResourceKey((Object)armorMaterial).orElseThrow()).location();
        ResourceLocation id = materialId.withSuffix("_armor");
        this.addTwoLayerTrimsSource(id, id, materialId);
    }

    public void addTwoLayerTrimsSource(Holder<ArmorMaterial> armorMaterial) {
        ResourceLocation materialId = ((ResourceKey)armorMaterial.unwrapKey().orElseThrow()).location();
        ResourceLocation id = materialId.withSuffix("_armor");
        this.addTwoLayerTrimsSource(id, id, materialId);
    }

    public void addThreeLayerTrimsSource(ArmorMaterial armorMaterial) {
        ResourceLocation materialId = ((ResourceKey)BuiltInRegistries.ARMOR_MATERIAL.getResourceKey((Object)armorMaterial).orElseThrow()).location();
        ResourceLocation id = materialId.withSuffix("_armor");
        this.addThreeLayerTrimsSource(id, id, materialId);
    }

    public void addThreeLayerTrimsSource(Holder<ArmorMaterial> armorMaterial) {
        ResourceLocation materialId = ((ResourceKey)armorMaterial.unwrapKey().orElseThrow()).location();
        ResourceLocation id = materialId.withSuffix("_armor");
        this.addThreeLayerTrimsSource(id, id, materialId);
    }

    public void addTwoLayerTrimsSource(ResourceLocation id, ResourceLocation overlayTextures, ResourceLocation overrideTextures) {
        this.addTrimsSource(id, TWO_LAYER_TEMPLATE, ClientMapKeys.TRIM_OVERLAYS.makeSubKey(overlayTextures), ClientMapKeys.TRIM_MATERIAL_OVERRIDES.makeSubKey(overrideTextures));
    }

    public void addThreeLayerTrimsSource(ResourceLocation id, ResourceLocation overlayTextures, ResourceLocation overrideTextures) {
        this.addTrimsSource(id, THREE_LAYER_TEMPLATE, ClientMapKeys.TRIM_OVERLAYS.makeSubKey(overlayTextures), ClientMapKeys.TRIM_MATERIAL_OVERRIDES.makeSubKey(overrideTextures));
    }

    public void addTrimsSource(ResourceLocation id, ResourceLocation template, ResourceLocation overlayTextures, ResourceLocation overrideTextures) {
        this.addTrimsSource(id, template, ClientMapKeys.TRIM_OVERLAYS.makeSubKey(overlayTextures), ClientMapKeys.TRIM_MATERIAL_OVERRIDES.makeSubKey(overrideTextures));
    }

    public void addTrimsSource(ResourceLocation id, ResourceLocation template, MapKey<ResourceLocation, ResourceLocation> overlayTextures, MapKey<ResourceLocation, ResourceLocation> overrideTextures) {
        Preconditions.checkArgument((overlayTextures.getType() == ClientMapTypes.TEXTURE_MAPPING && overrideTextures.getType() == ClientMapTypes.TEXTURE_MAPPING ? 1 : 0) != 0, (Object)"Textures must use the \"texture_mapping\" type");
        this.add(id, new TrimModelSource(template, TrimmedClientMapApi.getInstance().getSimpleMap(overlayTextures), TrimmedClientMapApi.getInstance().getSimpleMap(overrideTextures)));
    }

    public void add(ResourceLocation id, ModelSource modelSource) {
        if (this.modelSources.containsKey(id)) {
            throw new IllegalArgumentException("ModelSource already registered with id \"" + String.valueOf(id) + "\"");
        }
        this.modelSources.put(id, modelSource);
    }

    protected void onAdd(ResourceLocation id) {
    }

    public CompletableFuture<?> run(CachedOutput output) {
        this.addModelSources();
        return CompletableFuture.allOf((CompletableFuture[])this.modelSources.entrySet().stream().map(entry -> {
            JsonElement jsonElement = (JsonElement)ModelSourceRegistry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((ModelSource)entry.getValue())).getOrThrow();
            Path path = this.pathProvider.json((ResourceLocation)entry.getKey());
            return DataProvider.saveStable((CachedOutput)output, (JsonElement)jsonElement, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "ModelSourceDataProvider for " + this.modid;
    }
}

