/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.data.tag;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.api.client.tag.ClientTagKey;
import dev.dhyces.trimmed.api.data.client.tag.ClientTagBuilder;
import dev.dhyces.trimmed.api.data.client.tag.ClientTagFile;
import dev.dhyces.trimmed.api.data.client.tag.appenders.ClientTagAppender;
import dev.dhyces.trimmed.api.data.tag.NeoBaseClientTagDataProvider;
import dev.dhyces.trimmed.impl.client.maps.KeyResolvers;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class ClientTagDataProvider<T>
extends NeoBaseClientTagDataProvider<T, KeyResolver<T>> {
    public ClientTagDataProvider(PackOutput packOutput, String modid, KeyResolver<T> keyResolver, ExistingFileHelper existingFileHelper) {
        super(packOutput, modid, keyResolver, existingFileHelper);
    }

    protected abstract void addTags();

    public ClientTagAppender<T> tag(ClientTagKey<T> clientTagKey) {
        return new ClientTagAppender<T>(this.getOrCreateBuilder(clientTagKey));
    }

    public ClientTagAppender.Mapped<T> tag(ClientTagKey<T> clientTagKey, Function<T, @Nullable ResourceLocation> encoder) {
        return new ClientTagAppender.Mapped<T>(this.getOrCreateBuilder(clientTagKey), encoder);
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        this.addTags();
        return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(entry -> {
            DataResult jsonResult = ClientTagFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((ClientTagBuilder)entry.getValue()).build());
            JsonElement json = (JsonElement)jsonResult.getOrThrow();
            Path filePath = this.pathProvider.json((ResourceLocation)entry.getKey());
            return DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)json, (Path)filePath);
        }).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "ClientTagDataProvider<%s> for %s".formatted(KeyResolvers.getId(this.keyResolver), this.modid);
    }
}

