/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.maps;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.BaseMapCodec;
import dev.dhyces.trimmed.api.maps.MapKey;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface MapHolder<K, V> {
    public static <K, V, C extends BaseMapCodec<K, V> & Codec<Map<K, V>>> Codec<MapHolder<K, V>> fromBaseMapCodec(C baseMapCodec) {
        return ((Codec<Map<K, V>>)baseMapCodec).xmap(MapHolder::simpleWrapper, MapHolder::getMap);
    }

    default public MapKey<K, V> unwrapKeyOrThrow() {
        return this.getKey().orElseThrow(() -> new IllegalStateException("No key is present for map holder"));
    }

    default public Optional<MapKey<K, V>> getKey() {
        return Optional.ofNullable(this.unwrapKey());
    }

    @Nullable
    public MapKey<K, V> unwrapKey();

    public Map<K, V> getMap();

    public boolean isRequired(K var1);

    public boolean isBound();

    public static <K, V> MapHolder<K, V> simpleWrapper(final Map<K, V> map) {
        return new MapHolder<K, V>(){

            @Override
            @Nullable
            public MapKey<K, V> unwrapKey() {
                return null;
            }

            @Override
            public Map<K, V> getMap() {
                return map;
            }

            @Override
            public boolean isRequired(K key) {
                return true;
            }

            @Override
            public boolean isBound() {
                return true;
            }
        };
    }

    public static interface Typed<K, V, M extends Map<K, V>>
    extends MapHolder<K, V> {
        public M getMap();
    }
}

