/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.maps;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.api.client.map.ClientMapTypes;
import dev.dhyces.trimmed.api.maps.types.MapType;
import dev.dhyces.trimmed.api.util.CodecUtil;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class MapKey<K, V> {
    public static final MapCodec<MapKey<?, ?>> REGISTERED_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ClientMapTypes.CODEC.fieldOf("map_type").forGetter(MapKey::getType), (App)CodecUtil.TRIMMED_IDENTIFIER.fieldOf("map_key").forGetter(MapKey::getMapId)).apply((Applicative)instance, MapKey::of));
    private static final Interner<MapKey<?, ?>> INTERNER = Interners.newWeakInterner();
    private final MapType<K, V> type;
    @Nullable
    private final MapKey<K, V> baseKey;
    private final ResourceLocation id;

    public static <K, V> Codec<MapKey<K, V>> codec(MapType<K, V> mapType) {
        return ResourceLocation.CODEC.xmap(resourceLocation -> MapKey.of(mapType, resourceLocation), MapKey::compilePathAndIdNamespace);
    }

    private MapKey(MapType<K, V> mapType, @Nullable MapKey<K, V> baseKey, ResourceLocation id) {
        this.type = mapType;
        this.baseKey = baseKey;
        this.id = id;
    }

    public static <K, V> MapKey<K, V> baseKeyOf(MapType<K, V> mapType, ResourceLocation id) {
        return (MapKey)INTERNER.intern(new MapKey<K, V>(mapType, null, id));
    }

    public static <K, V> MapKey<K, V> fromBase(MapKey<K, V> baseKey, ResourceLocation id) {
        return (MapKey)INTERNER.intern(new MapKey<K, V>(baseKey.type, baseKey, id));
    }

    public static <K, V> MapKey<K, V> of(MapType<K, V> mapType, ResourceLocation id) {
        if (id.getPath().contains("/")) {
            ResourceLocation subKey;
            ResourceLocation baseKey;
            int firstSlashIndex = id.getPath().indexOf(47);
            int secondSlashIndex = id.getPath().indexOf(47, firstSlashIndex + 1);
            if (secondSlashIndex == -1) {
                baseKey = Trimmed.id(id.getPath().substring(0, firstSlashIndex));
                subKey = id.withPath(s -> s.substring(firstSlashIndex + 1));
            } else {
                baseKey = ResourceLocation.fromNamespaceAndPath((String)id.getPath().substring(0, firstSlashIndex), (String)id.getPath().substring(firstSlashIndex + 1, secondSlashIndex));
                subKey = id.withPath(s -> s.substring(secondSlashIndex + 1));
            }
            return MapKey.fromBase(MapKey.baseKeyOf(mapType, baseKey), subKey);
        }
        return MapKey.baseKeyOf(mapType, id);
    }

    public MapType<K, V> getType() {
        return this.type;
    }

    public ResourceLocation getMapId() {
        return this.id;
    }

    public MapKey<K, V> makeSubKey(ResourceLocation subId) {
        return MapKey.fromBase(this.baseKey == null ? this : this.baseKey, subId);
    }

    public MapKey<K, V> getParentKey() {
        Preconditions.checkArgument((this.baseKey != null ? 1 : 0) != 0, (Object)"This map key is the base key");
        return MapKey.fromBase(this.baseKey, this.id.withPath(s -> s.substring(0, s.lastIndexOf("/"))));
    }

    public MapKey<K, V> getBaseKey() {
        Preconditions.checkArgument((this.baseKey != null ? 1 : 0) != 0, (Object)"This map key is the base key");
        return this.baseKey;
    }

    public boolean isSubKey() {
        return this.baseKey != null;
    }

    public ResourceLocation compilePathAndIdNamespace() {
        if (this.baseKey == null) {
            return this.getMapId();
        }
        return this.id.withPrefix(this.baseKey.getMapId().getPath() + "/");
    }

    public String toString() {
        return "MapKey[type: " + String.valueOf(this.type) + ", id: " + String.valueOf(this.compilePathAndIdNamespace()) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapKey mapKey = (MapKey)o;
        return Objects.equals(this.type, mapKey.type) && Objects.equals(this.baseKey, mapKey.baseKey) && Objects.equals(this.id, mapKey.id);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseKey, this.id);
    }
}

