/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.maps.types;

import com.mojang.serialization.Codec;
import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.api.maps.types.MapType;
import dev.dhyces.trimmed.impl.client.maps.KeyResolvers;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class AdvancedMapType<K, V, M extends Map<K, V>>
implements MapType<K, V> {
    private final KeyResolver<K> keyResolver;
    private final Codec<V> valueCodec;
    @Nullable
    private final StreamCodec<RegistryFriendlyByteBuf, V> valueStreamCodec;
    private final boolean dataPackSynced;
    private final Supplier<M> mapSupplier;

    AdvancedMapType(KeyResolver<K> keyResolver, Codec<V> valueCodec, @Nullable StreamCodec<RegistryFriendlyByteBuf, V> valueStreamCodec, boolean dataPackSynced, @Nullable Supplier<M> mapSupplier) {
        this.keyResolver = keyResolver;
        this.valueCodec = valueCodec;
        this.valueStreamCodec = valueStreamCodec;
        this.dataPackSynced = dataPackSynced;
        this.mapSupplier = mapSupplier;
    }

    public static <K, V, M extends Map<K, V>> Builder<K, V, M> builder(KeyResolver<K> keyResolver, Codec<V> valueCodec) {
        return new Builder(keyResolver, valueCodec);
    }

    @Override
    public KeyResolver<K> getKeyResolver() {
        return this.keyResolver;
    }

    @Override
    public Codec<V> getValueCodec() {
        return this.valueCodec;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, V> getValueStreamCodec() {
        return this.valueStreamCodec;
    }

    @Override
    public boolean isDataPackSynced() {
        return this.dataPackSynced || this.keyResolver.requiresActiveWorld();
    }

    @Override
    public Map<K, V> createMap() {
        if (this.mapSupplier != null) {
            return (Map)this.mapSupplier.get();
        }
        return MapType.super.createMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancedMapType that = (AdvancedMapType)o;
        return this.dataPackSynced == that.dataPackSynced && Objects.equals(this.keyResolver, that.keyResolver) && Objects.equals(this.valueCodec, that.valueCodec) && Objects.equals(this.valueStreamCodec, that.valueStreamCodec) && Objects.equals(this.mapSupplier, that.mapSupplier);
    }

    public int hashCode() {
        return Objects.hash(this.keyResolver, this.valueCodec, this.valueStreamCodec, this.dataPackSynced, this.mapSupplier);
    }

    public String toString() {
        ResourceLocation resolverId = KeyResolvers.getId(this.keyResolver);
        return "AdvancedMapType[map_key_resolver: " + String.valueOf(resolverId == null ? "unregistered" : resolverId) + "]";
    }

    public static class Builder<K, V, M extends Map<K, V>>
    extends MapType.BaseBuilder<K, V> {
        private Supplier<M> mapSupplier;

        protected Builder(KeyResolver<K> keyResolver, Codec<V> valueCodec) {
            super(keyResolver, valueCodec);
        }

        public Builder<K, V, M> collectInto(Supplier<M> mapSupplier) {
            this.mapSupplier = mapSupplier;
            return this;
        }

        @Override
        public AdvancedMapType<K, V, M> build() {
            return new AdvancedMapType(this.keyResolver, this.valueCodec, this.valueStreamCodec, this.dataPackSynced, this.mapSupplier);
        }
    }
}

