/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.maps.types;

import com.mojang.serialization.Codec;
import dev.dhyces.trimmed.api.KeyResolver;
import dev.dhyces.trimmed.api.maps.types.AdvancedMapType;
import dev.dhyces.trimmed.api.maps.types.SimpleMapType;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public sealed interface MapType<K, V>
permits SimpleMapType, AdvancedMapType {
    public KeyResolver<K> getKeyResolver();

    public Codec<V> getValueCodec();

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, V> getValueStreamCodec();

    public boolean isDataPackSynced();

    default public Map<K, V> createMap() {
        if (this.getKeyResolver() instanceof KeyResolver.RegistryResolver) {
            return new Reference2ObjectLinkedOpenHashMap();
        }
        return new Object2ObjectLinkedOpenHashMap();
    }

    public static <K, V> SimpleMapType<K, V> simple(KeyResolver<K> keyResolver, Codec<V> valueCodec) {
        return new SimpleMapType<K, V>(keyResolver, valueCodec, null, false);
    }

    public static <K, V> SimpleMapType.Builder<K, V> simpleBuilder(KeyResolver<K> keyResolver, Codec<V> valueCodec) {
        return SimpleMapType.builder(keyResolver, valueCodec);
    }

    public static <K, V, M extends Map<K, V>> AdvancedMapType<K, V, M> advancedCollection(KeyResolver<K> keyResolver, Codec<V> valueCodec, Supplier<M> mapSupplier) {
        return new AdvancedMapType<K, V, M>(keyResolver, valueCodec, null, false, mapSupplier);
    }

    public static <K, V, M extends Map<K, V>> AdvancedMapType.Builder<K, V, M> advancedBuilder(KeyResolver<K> keyResolver, Codec<V> valueCodec) {
        return AdvancedMapType.builder(keyResolver, valueCodec);
    }

    public static abstract class BaseBuilder<K, V> {
        protected final KeyResolver<K> keyResolver;
        protected final Codec<V> valueCodec;
        @Nullable
        protected StreamCodec<RegistryFriendlyByteBuf, V> valueStreamCodec;
        protected boolean dataPackSynced = false;

        protected BaseBuilder(KeyResolver<K> keyResolver, Codec<V> valueCodec) {
            this.keyResolver = keyResolver;
            this.valueCodec = valueCodec;
        }

        public BaseBuilder<K, V> dataPackSynced() {
            this.dataPackSynced = true;
            return this;
        }

        public BaseBuilder<K, V> networkCodec(StreamCodec<RegistryFriendlyByteBuf, V> valueCodec) {
            this.valueStreamCodec = valueCodec;
            return this.dataPackSynced();
        }

        public BaseBuilder<K, V> networked() {
            this.valueStreamCodec = ByteBufCodecs.fromCodecWithRegistries(this.valueCodec);
            return this.dataPackSynced();
        }

        public abstract <T extends MapType<K, V>> T build();
    }
}

