/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.api.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.BaseMapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class LenientUnboundedMapCodec<K, V>
implements BaseMapCodec<K, V>,
Codec<Map<K, V>> {
    private final Codec<K> keyCodec;
    private final Codec<V> valueCodec;

    public LenientUnboundedMapCodec(Codec<K> keyCodec, Codec<V> elementCodec) {
        this.keyCodec = keyCodec;
        this.valueCodec = elementCodec;
    }

    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(tMapLike -> this.decode(ops, (MapLike)tMapLike)).map(kvMap -> Pair.of((Object)kvMap, (Object)input));
    }

    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object2ObjectOpenHashMap successful = new Object2ObjectOpenHashMap();
        Stream.Builder errors = Stream.builder();
        DataResult result = input.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (arg_0, arg_1) -> this.lambda$decode$5(ops, (Map)successful, errors, arg_0, arg_1), (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
        Map finished = Collections.unmodifiableMap(successful);
        return result.map(unit -> finished).setPartial(finished).mapError(s -> s + " missed input: " + String.valueOf(ops.createMap(errors.build())));
    }

    public abstract boolean shouldSkipKey(DataResult<K> var1, V var2);

    public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
        return this.encode(input, ops, ops.mapBuilder()).build(prefix);
    }

    public Codec<K> keyCodec() {
        return this.keyCodec;
    }

    public Codec<V> elementCodec() {
        return this.valueCodec;
    }

    private /* synthetic */ DataResult lambda$decode$5(DynamicOps ops, Map successful, Stream.Builder errors, DataResult dataResult, Pair ttPair) {
        Object existingValue;
        DataResult valueResult;
        DataResult keyResult = this.keyCodec.parse(ops, ttPair.getFirst());
        DataResult entry = keyResult.apply2stable(Pair::of, valueResult = this.valueCodec.parse(ops, ttPair.getSecond()));
        Optional entryOptional = entry.resultOrPartial();
        if (entryOptional.isPresent() && (existingValue = successful.putIfAbsent(((Pair)entryOptional.get()).getFirst(), ((Pair)entryOptional.get()).getSecond())) != null) {
            errors.add(ttPair);
            return dataResult.apply2stable((u, p) -> u, DataResult.error(() -> "Duplicate entry for key: '" + String.valueOf(((Pair)entryOptional.get()).getFirst()) + "'"));
        }
        if (!(!entry.isError() || valueResult.isSuccess() && this.shouldSkipKey(keyResult, valueResult.getOrThrow()))) {
            errors.add(ttPair);
        }
        return dataResult.apply2stable((unit, o) -> unit, entry);
    }
}

