/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class InfoToast
implements Toast {
    public static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private static final int MIDDLE_OF_TOAST = 24;
    private final Component title;
    private final List<FormattedCharSequence> messageLines;
    private final int height;

    public InfoToast(Component title, Component message) {
        this.title = title;
        this.messageLines = Minecraft.getInstance().font.split((FormattedText)message, this.width() - 8);
        int n = this.messageLines.size();
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.height = 19 + n * (9 + 2);
    }

    public static InfoToast reloadClientInfo() {
        return new InfoToast((Component)Component.translatable((String)"trimmed.info.datapacksReloadedTitle").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true))), (Component)Component.translatable((String)"trimmed.info.datapacksReloaded"));
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLast) {
        if (this.height() <= 32) {
            guiGraphics.blit(TEXTURE, 0, 0, 0, 0, this.width(), this.height());
        } else {
            guiGraphics.blit(TEXTURE, 0, 0, 0, 0, this.width(), 4);
            int middleAmount = this.height() - 8;
            int yPos = 4;
            for (int iterTimes = (int)Math.ceil((float)middleAmount / 28.0f); iterTimes >= 0; --iterTimes) {
                int amountToDraw = Math.min(24, middleAmount);
                guiGraphics.blit(TEXTURE, 0, yPos, 0, 4, this.width(), amountToDraw);
                middleAmount -= amountToDraw;
                yPos += amountToDraw;
            }
            guiGraphics.blit(TEXTURE, 0, yPos, 0, 28, this.width(), 4);
        }
        Font font = toastComponent.getMinecraft().font;
        guiGraphics.drawString(font, this.title, 5, 5, 0xFFFFFF);
        int lineNum = 1;
        for (FormattedCharSequence messageLine : this.messageLines) {
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, messageLine, 5, 7 + (9 + 2) * lineNum++, 0xFFFFFF);
        }
        return (double)timeSinceLast > 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public int height() {
        return this.height;
    }
}

