/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.maps.manager;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.api.data.map.MapAppendElement;
import dev.dhyces.trimmed.api.data.map.MapBuilder;
import dev.dhyces.trimmed.api.data.map.MapFile;
import dev.dhyces.trimmed.api.maps.MapHolder;
import dev.dhyces.trimmed.api.maps.MapKey;
import dev.dhyces.trimmed.api.maps.types.MapType;
import dev.dhyces.trimmed.modhelper.services.Services;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.GsonHelper;

public final class MapHandler<K, V> {
    private final MapKey<K, V> baseKey;
    private final Map<MapKey<K, V>, ClientMapHolder<K, V, Map<K, V>>> holders;

    public MapHandler(MapKey<K, V> baseKey) {
        this.baseKey = baseKey;
        this.holders = new Reference2ObjectOpenHashMap();
    }

    MapHolder<K, V> getHolder(MapKey<K, V> mapKey) {
        return this.getOrCreateHolder(mapKey);
    }

    void clear() {
        this.holders.values().forEach(kvMapClientMapHolder -> {
            kvMapClientMapHolder.backing = null;
            kvMapClientMapHolder.optionalKeys = null;
        });
    }

    private ClientMapHolder<K, V, Map<K, V>> getOrCreateHolder(MapKey<K, V> key) {
        return this.holders.computeIfAbsent(key, ClientMapHolder::new);
    }

    void parse(ResourceLocation resolverPath, FileToIdConverter converter, ResourceManager resourceManager, DynamicOps<JsonElement> jsonOps) {
        MapFile<V> base = this.readStack(this.baseKey.getMapId(), resourceManager.getResourceStack(resolverPath.withSuffix(".json")), jsonOps);
        Map<ResourceLocation, MapFile<MapFile>> children = this.readResources(converter, resourceManager, jsonOps);
        if (base.map().isEmpty() && base.appendElements().isEmpty() && children.isEmpty()) {
            Trimmed.LOGGER.debug("No maps to read, skipping %s".formatted(resolverPath));
            return;
        }
        DependencySorter dependencySorter = new DependencySorter();
        dependencySorter.addEntry((Object)this.baseKey.getMapId(), new Entry<V>(base));
        children.forEach((resourceLocation, vMapFile) -> dependencySorter.addEntry(resourceLocation, new Entry(vMapFile)));
        dependencySorter.orderByDependencies((resourceLocation, vEntry) -> {
            MapKey<K, V> key = this.baseKey.getMapId().equals(resourceLocation) ? this.baseKey : MapKey.fromBase(this.baseKey, resourceLocation.withPath(s -> s.substring(s.indexOf(47) + 1)));
            ClientMapHolder<K, V, Map<K, V>> holder = this.getOrCreateHolder(key);
            ObjectOpenHashSet optionalElements = new ObjectOpenHashSet();
            Map finishedMap = this.baseKey.getType().createMap();
            for (Map.Entry entry : vEntry.file().map().entrySet()) {
                K keyVal = this.baseKey.getType().getKeyResolver().decode(entry.getKey(), jsonOps);
                if (keyVal == null) {
                    if (!entry.getValue().isRequired()) continue;
                    throw new IllegalStateException("Could not parse required element for \"%s\"".formatted(entry.getKey()));
                }
                finishedMap.put(keyVal, entry.getValue().value());
                if (entry.getValue().isRequired()) continue;
                optionalElements.add(keyVal);
            }
            for (MapAppendElement element : vEntry.file().appendElements()) {
                MapKey<K, V> subKey = MapKey.fromBase(this.baseKey, element.mapId());
                ClientMapHolder<K, V, Map<K, V>> mapHolder = this.getOrCreateHolder(subKey);
                if (mapHolder.isBound()) {
                    finishedMap.putAll(mapHolder.getMap());
                    continue;
                }
                if (!element.isRequired()) continue;
                throw new IllegalStateException("Required entry \"%s\" cannot be found for \"%s\"".formatted(element.mapId(), resourceLocation));
            }
            holder.update(finishedMap, (Set<K>)optionalElements);
        });
    }

    private Map<ResourceLocation, MapFile<V>> readResources(FileToIdConverter converter, ResourceManager resourceManager, DynamicOps<JsonElement> jsonOps) {
        return (Map)converter.listMatchingResourceStacks(resourceManager).entrySet().stream().map(entry -> {
            ResourceLocation id = converter.fileToId((ResourceLocation)entry.getKey());
            return Map.entry(id, this.readStack(id, (List)entry.getValue(), jsonOps));
        }).collect(Util.toMap());
    }

    private MapFile<V> readStack(ResourceLocation fileName, List<Resource> resourceStack, DynamicOps<JsonElement> jsonOps) {
        MapType<K, V> mapType = this.baseKey.getType();
        MapBuilder<V> builder = new MapBuilder<V>();
        for (Resource resource : resourceStack) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject json = GsonHelper.parse((Reader)reader);
                    Optional<MapFile<V>> result = Services.PLATFORM_HELPER.decodeWithConditions(MapFile.codec(mapType.getValueCodec()), jsonOps, json);
                    if (result.isEmpty()) {
                        Trimmed.LOGGER.debug("Skipping loading client map {} as its conditions were not met", (Object)fileName);
                        continue;
                    }
                    MapFile<V> mapFile = result.get();
                    if (mapFile.shouldReplace()) {
                        builder = new MapBuilder();
                    }
                    builder.merge(mapFile);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (JsonParseException | IOException e) {
                throw new RuntimeException("Failed to read %s from %s: ".formatted(fileName, resource.source().packId()), e);
            }
        }
        return builder.build();
    }

    static class ClientMapHolder<K, V, M extends Map<K, V>>
    implements MapHolder.Typed<K, V, M> {
        private final MapKey<K, V> key;
        M backing;
        Set<K> optionalKeys;

        public ClientMapHolder(MapKey<K, V> key) {
            this.key = key;
        }

        private void update(M backing, Set<K> optionalKeys) {
            this.backing = backing;
            this.optionalKeys = optionalKeys;
        }

        @Override
        public MapKey<K, V> unwrapKey() {
            return this.key;
        }

        @Override
        public M getMap() {
            if (this.backing == null) {
                throw new IllegalStateException("Cannot access map for " + String.valueOf(this.key) + " because it doesn't exist!");
            }
            return this.backing;
        }

        @Override
        public boolean isRequired(K key) {
            return !this.optionalKeys.contains(key);
        }

        @Override
        public boolean isBound() {
            return this.backing != null;
        }
    }

    private record Entry<V>(MapFile<V> file) implements DependencySorter.Entry<ResourceLocation>
    {
        public void visitRequiredDependencies(Consumer<ResourceLocation> visitor) {
            this.file.appendElements().forEach(mapAppendElement -> {
                if (mapAppendElement.isRequired()) {
                    visitor.accept(mapAppendElement.mapId());
                }
            });
        }

        public void visitOptionalDependencies(Consumer<ResourceLocation> visitor) {
            this.file.appendElements().forEach(mapAppendElement -> {
                if (!mapAppendElement.isRequired()) {
                    visitor.accept(mapAppendElement.mapId());
                }
            });
        }
    }
}

