/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.models.override;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dhyces.trimmed.api.client.override.provider.ItemOverrideProvider;
import dev.dhyces.trimmed.api.data.model.override.ItemOverrideFile;
import dev.dhyces.trimmed.impl.client.models.override.ItemOverrideRegistry;
import dev.dhyces.trimmed.modhelper.services.Services;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemOverrideReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonObject>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Trimmed/Item Model Overrides");
    public static final String OVERRIDES_DIRECTORY = "trimmed/item_model_overrides";
    private static final FileToIdConverter OVERRIDES_FINDER = FileToIdConverter.json((String)"trimmed/item_model_overrides");

    protected Map<ResourceLocation, List<JsonObject>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Object2ObjectOpenHashMap files = new Object2ObjectOpenHashMap();
        for (Map.Entry entry : OVERRIDES_FINDER.listMatchingResourceStacks(resourceManager).entrySet()) {
            ResourceLocation id = OVERRIDES_FINDER.fileToId((ResourceLocation)entry.getKey());
            ObjectArrayList jsons = new ObjectArrayList();
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        jsons.add(GsonHelper.parse((Reader)reader, (boolean)true));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.error("Could not read %s: ".formatted(entry.getKey()), e);
                }
            }
            files.put((Object)id, (Object)jsons);
        }
        return files;
    }

    protected void apply(Map<ResourceLocation, List<JsonObject>> jsonFiles, ResourceManager resourceManager, ProfilerFiller profiler) {
        ItemOverrideRegistry.clearRegistry();
        for (Map.Entry<ResourceLocation, List<JsonObject>> entry : jsonFiles.entrySet()) {
            ObjectOpenHashSet combined = new ObjectOpenHashSet();
            try {
                for (JsonObject json : entry.getValue()) {
                    Optional<ItemOverrideFile> result = Services.PLATFORM_HELPER.decodeWithConditions(ItemOverrideFile.CODEC, (DynamicOps<JsonElement>)JsonOps.INSTANCE, json);
                    if (result.isEmpty()) {
                        LOGGER.debug("Skipping loading item overrides from {} as its conditions were not met", (Object)entry.getKey());
                        continue;
                    }
                    ItemOverrideFile overrideFile = result.get();
                    if (overrideFile.replace()) {
                        combined.clear();
                    }
                    combined.addAll(overrideFile.overrideProviders());
                }
            }
            catch (JsonParseException e) {
                LOGGER.error("Could not read %s: ".formatted(entry.getKey()), (Throwable)e);
            }
            ItemOverrideRegistry.addOverrideSet(entry.getKey(), (Set<ItemOverrideProvider>)ObjectSets.unmodifiable((ObjectSet)combined));
        }
    }
}

