/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.models.override.provider;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.dhyces.trimmed.api.client.override.provider.ItemOverrideProviderType;
import dev.dhyces.trimmed.api.util.CodecUtil;
import net.minecraft.resources.ResourceLocation;

public class ItemOverrideProviderRegistry {
    private static final BiMap<ResourceLocation, ItemOverrideProviderType<?>> PROVIDER_TYPE_MAP = HashBiMap.create();
    public static final Codec<ItemOverrideProviderType<?>> CODEC = CodecUtil.TRIMMED_IDENTIFIER.flatXmap(id -> {
        if (!PROVIDER_TYPE_MAP.containsKey(id)) {
            return DataResult.error(() -> "Item override provider type %s does not exist!".formatted(id));
        }
        return DataResult.success((Object)((ItemOverrideProviderType)PROVIDER_TYPE_MAP.get(id)));
    }, type -> {
        if (!PROVIDER_TYPE_MAP.inverse().containsKey(type)) {
            return DataResult.error(() -> "Item override provider type is not registered! " + String.valueOf(type.getCodec()));
        }
        return DataResult.success((Object)((ResourceLocation)PROVIDER_TYPE_MAP.inverse().get(type)));
    });

    public static void init() {
        ItemOverrideProviderType.bootstrap();
    }

    public static void register(ResourceLocation id, ItemOverrideProviderType<?> providerType) {
        if (PROVIDER_TYPE_MAP.putIfAbsent((Object)id, providerType) != null) {
            throw new IllegalArgumentException("ItemOverrideProviderType already registered with id \"" + String.valueOf(id) + "\"");
        }
    }
}

