/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.models.template;

import com.google.gson.JsonObject;
import dev.dhyces.trimmed.Trimmed;
import dev.dhyces.trimmed.impl.client.models.template.StringTemplate;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public final class ModelTemplateManager {
    private static final FileToIdConverter TEMPLATE_CONVERTER = new FileToIdConverter("trimmed/model_templates", ".json");
    private final Map<ResourceLocation, StringTemplate> templates = new Object2ObjectOpenHashMap();

    private ModelTemplateManager() {
    }

    private StringTemplate getTemplate(ResourceLocation id) {
        StringTemplate template = this.templates.get(id);
        if (template == null) {
            throw new IllegalArgumentException("Template %s does not exist");
        }
        return template;
    }

    public String process(ResourceLocation id, Function<String, String> replacer) {
        return this.getTemplate(id).process(replacer);
    }

    public JsonObject processAsJson(ResourceLocation id, Function<String, String> replacer) {
        return GsonHelper.parse((String)this.process(id, replacer), (boolean)true);
    }

    public static CompletableFuture<ModelTemplateManager> load(ResourceManager resourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ModelTemplateManager manager = new ModelTemplateManager();
            for (Map.Entry entry : TEMPLATE_CONVERTER.listMatchingResources(resourceManager).entrySet()) {
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                    try {
                        ResourceLocation id = TEMPLATE_CONVERTER.fileToId((ResourceLocation)entry.getKey());
                        String rawData = reader.lines().collect(Collectors.joining());
                        manager.templates.put(id, StringTemplate.of(rawData));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    Trimmed.LOGGER.error("Failed to read %s from %s: ".formatted(entry.getKey(), ((Resource)entry.getValue()).source().packId()), (Throwable)e);
                }
            }
            return manager;
        }, executor);
    }
}

