/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.impl.client.models.template;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class StringTemplate {
    public static final Codec<StringTemplate> CODEC = Codec.STRING.xmap(StringTemplate::of, StringTemplate::asOriginalString);
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\$\\{[a-z_0-9]+\\}");
    private final List<String> staticStrings;
    private final Int2ObjectMap<String> indexedStrings;

    StringTemplate(List<String> staticStrings, Int2ObjectMap<String> indexedStrings) {
        this.staticStrings = staticStrings;
        this.indexedStrings = indexedStrings;
    }

    public static StringTemplate of(String rawData) {
        ObjectArrayList staticStrings = new ObjectArrayList();
        Int2ObjectArrayMap replacementKeys = new Int2ObjectArrayMap();
        AtomicInteger cursor = new AtomicInteger();
        TEMPLATE_PATTERN.matcher(rawData).results().forEach(arg_0 -> StringTemplate.lambda$of$0((ObjectList)staticStrings, rawData, cursor, (Int2ObjectMap)replacementKeys, arg_0));
        staticStrings.add((Object)rawData.substring(cursor.getPlain()));
        return new StringTemplate((List<String>)ObjectLists.unmodifiable((ObjectList)staticStrings), (Int2ObjectMap<String>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)replacementKeys));
    }

    public Collection<String> getFragments() {
        return this.staticStrings;
    }

    public Collection<String> getVariables() {
        return this.indexedStrings.values().stream().distinct().toList();
    }

    public String process(Function<String, String> replacer) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.staticStrings.size(); ++i) {
            builder.append(this.staticStrings.get(i));
            String key = (String)this.indexedStrings.get(i);
            if (key == null) continue;
            String replacement = replacer.apply(key);
            if (replacement == null) {
                throw new IllegalStateException("Cannot get replacement for \"" + key + "\"");
            }
            builder.append(replacement);
        }
        return builder.toString();
    }

    public String asOriginalString() {
        return this.process(s -> "${" + s + "}");
    }

    private static /* synthetic */ void lambda$of$0(ObjectList staticStrings, String rawData, AtomicInteger cursor, Int2ObjectMap replacementKeys, MatchResult matchResult) {
        staticStrings.add((Object)rawData.substring(cursor.getPlain(), matchResult.start()));
        cursor.setPlain(matchResult.end());
        String key = matchResult.group().substring(2, matchResult.group().length() - 1);
        replacementKeys.put(replacementKeys.size(), (Object)key);
    }
}

