/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.trimmed.modhelper.services.helpers;

import dev.dhyces.trimmed.api.TrimmedClientApiConsumer;
import dev.dhyces.trimmed.api.client.TrimmedClientApiEntrypoint;
import dev.dhyces.trimmed.impl.ModApiConsumer;
import dev.dhyces.trimmed.modhelper.services.helpers.ClientHelper;
import java.lang.annotation.ElementType;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;

public class NeoClientHelper
implements ClientHelper {
    @Override
    public List<ModApiConsumer<TrimmedClientApiEntrypoint>> getClientApiConsumers() {
        return ModList.get().getAllScanData().stream().flatMap(modFileScanData -> modFileScanData.getAnnotatedBy(TrimmedClientApiConsumer.class, ElementType.TYPE)).map(annotationData -> {
            TrimmedClientApiEntrypoint apiEntrypoint;
            Class<?> clazz;
            String modid = (String)annotationData.annotationData().get("value");
            try {
                clazz = this.getClass().getClassLoader().loadClass(annotationData.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                apiEntrypoint = (TrimmedClientApiEntrypoint)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Could not find valid api constructor for mod id " + modid + ". Make sure the constructor has no parameters and is public.", e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Client api entrypoint for " + modid + " must implement TrimmedClientRegistration!", e);
            }
            return new ModApiConsumer<TrimmedClientApiEntrypoint>(modid, apiEntrypoint);
        }).toList();
    }

    @Override
    public BakedModel getModel(ResourceLocation resourceId) {
        return Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)resourceId));
    }
}

