/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.blockentities;

import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Leviathan.The_Leviathan_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.cataclysm.init.ModTileentites;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class AltarOfAbyss_Block_Entity
extends BlockEntity
implements Clearable {
    public int tickCount;
    private static final int NUM_SLOTS = 1;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    public boolean summoningthis = false;
    public int summoningticks = 0;
    private float chompProgress;
    private float prevChompProgress;
    private final RandomSource rnd = RandomSource.create();

    public AltarOfAbyss_Block_Entity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileentites.ALTAR_OF_ABYSS.get(), pos, state);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, AltarOfAbyss_Block_Entity entity) {
        entity.tick();
    }

    public void tick() {
        ++this.tickCount;
        this.summoningthis = false;
        this.prevChompProgress = this.chompProgress;
        if (!this.getItem(0).isEmpty() && this.getItem(0).getItem() == ModItems.ABYSSAL_SACRIFICE.get()) {
            this.summoningthis = true;
            if (this.summoningticks == 1) {
                ScreenShake_Entity.ScreenShake(this.level, Vec3.atCenterOf((Vec3i)this.getBlockPos()), 20.0f, 0.03f, 0, 150);
            }
            if (this.summoningticks > 118 && this.summoningticks < 121) {
                this.Sphereparticle(3.0f, 3.0f);
            }
            if (this.summoningticks > 121) {
                this.BlockBreaking(3, 6, 3);
                The_Leviathan_Entity leviathan = (The_Leviathan_Entity)((EntityType)ModEntities.THE_LEVIATHAN.get()).create(this.level);
                if (leviathan != null) {
                    boolean flag;
                    leviathan.setPos((float)this.getBlockPos().getX() + 0.5f, this.getBlockPos().getY() + 3, (float)this.getBlockPos().getZ() + 0.5f);
                    leviathan.setHomePos(this.getBlockPos());
                    if (!this.level.isClientSide && (flag = this.level.addFreshEntity((Entity)leviathan))) {
                        this.items.set(0, (Object)ItemStack.EMPTY);
                    }
                }
            }
        }
        if (this.summoningthis && this.chompProgress < 30.0f) {
            this.chompProgress += 1.0f;
        }
        if (!this.summoningthis && this.chompProgress > 0.0f) {
            this.chompProgress -= 1.0f;
        }
        this.summoningticks = !this.summoningthis ? 0 : ++this.summoningticks;
    }

    public float getChompProgress(float partialTick) {
        return this.prevChompProgress + (this.chompProgress - this.prevChompProgress) * partialTick;
    }

    private void BlockBreaking(int x, int y, int z) {
        int MthX = Mth.floor((float)this.getBlockPos().getX());
        int MthY = Mth.floor((float)this.getBlockPos().getY());
        int MthZ = Mth.floor((float)this.getBlockPos().getZ());
        for (int k2 = -x; k2 <= x; ++k2) {
            for (int l2 = -z; l2 <= z; ++l2) {
                for (int j = 0; j <= y; ++j) {
                    int i3 = MthX + k2;
                    int k = MthY + j;
                    int l = MthZ + l2;
                    BlockPos blockpos = new BlockPos(i3, k, l);
                    BlockState block = this.level.getBlockState(blockpos);
                    if (block == Blocks.AIR.defaultBlockState() || block.is(ModTag.ALTAR_DESTROY_IMMUNE)) continue;
                    this.level.destroyBlock(blockpos, false);
                }
            }
        }
    }

    private void Sphereparticle(float height, float size) {
        double d0 = (float)this.getBlockPos().getX() + 0.5f;
        double d1 = (float)this.getBlockPos().getY() + height;
        double d2 = (float)this.getBlockPos().getZ() + 0.5f;
        for (float i = -size; i <= size; i += 1.0f) {
            for (float j = -size; j <= size; j += 1.0f) {
                for (float k = -size; k <= size; k += 1.0f) {
                    double d3 = (double)j + (this.rnd.nextDouble() - this.rnd.nextDouble()) * 0.5;
                    double d4 = (double)i + (this.rnd.nextDouble() - this.rnd.nextDouble()) * 0.5;
                    double d5 = (double)k + (this.rnd.nextDouble() - this.rnd.nextDouble()) * 0.5;
                    double d6 = (double)Mth.sqrt((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.rnd.nextGaussian() * 0.05;
                    this.level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                    if (i == -size || i == size || j == -size || j == size) continue;
                    k += size * 2.0f - 1.0f;
                }
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.getItems().set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public void placeItem(@Nullable LivingEntity entity, int index, ItemStack stack) {
        this.getItems().set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
        this.markUpdated();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void loadAdditional(CompoundTag p_155312_, HolderLookup.Provider p_324612_) {
        super.loadAdditional(p_155312_, p_324612_);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)p_155312_, this.items, (HolderLookup.Provider)p_324612_);
    }

    protected void saveAdditional(CompoundTag p_187486_, HolderLookup.Provider p_324612_) {
        super.saveAdditional(p_187486_, p_324612_);
        ContainerHelper.saveAllItems((CompoundTag)p_187486_, this.items, (boolean)true, (HolderLookup.Provider)p_324612_);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_324612_) {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compoundtag, this.items, (boolean)true, (HolderLookup.Provider)p_324612_);
        return compoundtag;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void dowse() {
        if (this.level != null) {
            this.markUpdated();
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput p_338534_) {
        super.applyImplicitComponents(p_338534_);
        ((ItemContainerContents)p_338534_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338620_) {
        super.collectImplicitComponents(p_338620_);
        p_338620_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(CompoundTag p_332690_) {
        p_332690_.remove("Items");
    }
}

