/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.upgrades;

import dan200.computercraft.api.upgrades.UpgradeType;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface UpgradeBase {
    public UpgradeType<?> getType();

    public Component getAdjective();

    public ItemStack getCraftingItem();

    default public ItemStack getUpgradeItem(DataComponentPatch upgradeData) {
        return this.getCraftingItem();
    }

    default public DataComponentPatch getUpgradeData(ItemStack stack) {
        return DataComponentPatch.EMPTY;
    }

    default public boolean isItemSuitable(ItemStack stack) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.getCraftingItem(), (ItemStack)stack);
    }

    public static String getDefaultAdjective(ResourceLocation id) {
        return Util.makeDescriptionId((String)"upgrade", (ResourceLocation)id) + ".adjective";
    }
}

