/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.recipe.function.RecipeFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class CopyComponents
implements RecipeFunction {
    public static final MapCodec<CopyComponents> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("from").forGetter(x -> x.from), (App)DataComponentType.CODEC.listOf().optionalFieldOf("include").forGetter(x -> x.include), (App)DataComponentType.CODEC.listOf().optionalFieldOf("exclude").forGetter(x -> x.exclude)).apply((Applicative)instance, CopyComponents::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CopyComponents> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, x -> x.from, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DataComponentType.STREAM_CODEC.apply(ByteBufCodecs.list())), x -> x.include, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DataComponentType.STREAM_CODEC.apply(ByteBufCodecs.list())), x -> x.exclude, CopyComponents::new);
    private final Ingredient from;
    private final Optional<List<DataComponentType<?>>> include;
    private final Optional<List<DataComponentType<?>>> exclude;
    @Nullable
    private final Set<DataComponentType<?>> includeSet;
    @Nullable
    private final Set<DataComponentType<?>> excludeSet;

    public CopyComponents(Ingredient from) {
        this(from, Optional.empty(), Optional.empty());
    }

    public CopyComponents(ItemLike from) {
        this(Ingredient.of((ItemLike[])new ItemLike[]{from}));
    }

    private CopyComponents(Ingredient from, Optional<List<DataComponentType<?>>> include, Optional<List<DataComponentType<?>>> exclude) {
        this.from = from;
        this.include = include.map(List::copyOf);
        this.exclude = exclude.map(List::copyOf);
        this.includeSet = include.map(Set::copyOf).orElse(null);
        this.excludeSet = exclude.map(Set::copyOf).orElse(null);
    }

    @Override
    public RecipeFunction.Type<?> getType() {
        return (RecipeFunction.Type)ModRegistry.RecipeFunctions.COPY_COMPONENTS.get();
    }

    @Override
    public ItemStack apply(CraftingInput container, ItemStack result) {
        for (ItemStack item : container.items()) {
            if (!this.from.test(item)) continue;
            this.applyPatch(item.getComponentsPatch(), result);
            break;
        }
        return result;
    }

    private void applyPatch(DataComponentPatch patch, ItemStack result) {
        if (this.includeSet == null && this.excludeSet == null) {
            result.applyComponents(patch);
            return;
        }
        for (Map.Entry component : patch.entrySet()) {
            DataComponentType type = (DataComponentType)component.getKey();
            if (this.includeSet != null && !this.includeSet.contains(type) || this.excludeSet != null && this.excludeSet.contains(type)) continue;
            CopyComponents.unsafeSetComponent(result, type, ((Optional)component.getValue()).orElse(null));
        }
    }

    private static <T> void unsafeSetComponent(ItemStack stack, DataComponentType<?> type, @Nullable T value) {
        stack.set(type, value);
    }

    public static Builder builder(Ingredient ingredient) {
        return new Builder(ingredient);
    }

    public static Builder builder(ItemLike ingredient) {
        return new Builder(Ingredient.of((ItemLike[])new ItemLike[]{ingredient}));
    }

    public static final class Builder {
        private final Ingredient from;
        @Nullable
        private List<DataComponentType<?>> include;
        @Nullable
        private List<DataComponentType<?>> exclude;

        private Builder(Ingredient from) {
            this.from = from;
        }

        public Builder include(DataComponentType<?> type) {
            if (this.include == null) {
                this.include = new ArrayList();
            }
            this.include.add(type);
            return this;
        }

        public Builder exclude(DataComponentType<?> type) {
            if (this.exclude == null) {
                this.exclude = new ArrayList();
            }
            this.exclude.add(type);
            return this;
        }

        public CopyComponents build() {
            return new CopyComponents(this.from, Optional.ofNullable(this.include), Optional.ofNullable(this.exclude));
        }
    }
}

