/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.forge;

import net.minecraft.client.gui.screens.Screen;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.anti_ad.mc.common.input.GlobalInputHandler;
import org.anti_ad.mc.common.input.GlobalScreenEventListener;
import org.anti_ad.mc.common.vanilla.Vanilla;

public class CommonForgeEventHandler {
    private int lastMods = 0;

    @SubscribeEvent
    public void onKeyLast(InputEvent.Key event) {
        if (Vanilla.INSTANCE.screen() == null) {
            GlobalInputHandler.INSTANCE.onKey(event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers(), true, 0L);
        }
    }

    @SubscribeEvent
    public void onKeyPressed(ScreenEvent.KeyPressed.Pre event) {
        this.onScreenKey(event.getKeyCode(), event.getScanCode(), 1, event.getModifiers(), (ScreenEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyPressed(event.getKeyCode(), event.getScanCode(), event.getModifiers(), true));
    }

    @SubscribeEvent
    public void onKeyRelease(ScreenEvent.KeyReleased.Pre event) {
        this.onScreenKey(event.getKeyCode(), event.getScanCode(), 0, event.getModifiers(), (ScreenEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyReleased(event.getKeyCode(), event.getScanCode(), event.getModifiers(), true));
    }

    @SubscribeEvent
    public void onKeyPressedPost(ScreenEvent.KeyPressed.Post event) {
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyPressed(event.getKeyCode(), event.getScanCode(), event.getModifiers(), false));
    }

    @SubscribeEvent
    public void onKeyReleasePost(ScreenEvent.KeyReleased.Post event) {
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyReleased(event.getKeyCode(), event.getScanCode(), event.getModifiers(), false));
    }

    private void onScreenKey(int key, int scanCode, int action, int modifiers, ScreenEvent event) {
        Screen lastScreen = Vanilla.INSTANCE.screen();
        long handle = Vanilla.INSTANCE.window().getWindow();
        boolean result = GlobalInputHandler.INSTANCE.onKey(key, scanCode, action, modifiers, true, handle);
    }

    @SubscribeEvent
    public void onMouseButtonLast(InputEvent.MouseButton.Post event) {
        if (Vanilla.INSTANCE.screen() == null) {
            GlobalInputHandler.INSTANCE.onMouseButton(event.getButton(), event.getAction(), event.getModifiers());
        }
    }

    @SubscribeEvent
    public void onMouseClicked(ScreenEvent.MouseButtonPressed.Pre event) {
        this.onScreenMouseButton(event.getButton(), 1, this.lastMods, (ICancellableEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onMouseClicked(event.getMouseX(), event.getMouseY(), event.getButton(), true));
    }

    @SubscribeEvent
    public void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        this.onScreenMouseButton(event.getButton(), 0, this.lastMods, (ICancellableEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onMouseReleased(event.getMouseX(), event.getMouseY(), event.getButton(), true));
    }

    @SubscribeEvent
    public void onMouseClickedPost(ScreenEvent.MouseButtonPressed.Post event) {
        GlobalScreenEventListener.INSTANCE.onMouseClicked(event.getMouseX(), event.getMouseY(), event.getButton(), false);
    }

    @SubscribeEvent
    public void onMouseReleasedPost(ScreenEvent.MouseButtonReleased.Post event) {
        GlobalScreenEventListener.INSTANCE.onMouseReleased(event.getMouseX(), event.getMouseY(), event.getButton(), false);
    }

    private void onScreenMouseButton(int button, int action, int mods, ICancellableEvent event) {
        Screen lastScreen = Vanilla.INSTANCE.screen();
        boolean result = GlobalInputHandler.INSTANCE.onMouseButton(button, action, mods);
        event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
    }

    @SubscribeEvent
    public void onRawMouse(InputEvent.MouseButton.Pre event) {
        this.lastMods = event.getModifiers();
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        double deltaX = event.getScrollDeltaX();
        double deltaY = event.getScrollDeltaY();
        if (deltaX != 0.0) {
            event.setCanceled(CommonForgeEventHandler.processHorizontalScrollEvent(deltaX));
        }
        if (deltaY != 0.0) {
            event.setCanceled(CommonForgeEventHandler.processVerticalScrollEvent(deltaY));
        }
    }

    @SubscribeEvent
    public void onGuiMouseScroll(ScreenEvent.MouseScrolled.Pre event) {
        boolean result;
        Screen lastScreen;
        double deltaX = event.getScrollDeltaX();
        double deltaY = event.getScrollDeltaY();
        if (deltaX != 0.0) {
            lastScreen = Vanilla.INSTANCE.screen();
            result = CommonForgeEventHandler.processHorizontalScrollEvent(deltaX);
            result = CommonForgeEventHandler.processHorizontalScrollGUIEvent(deltaX, event.getMouseX(), event.getMouseY()) || result;
            event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
        }
        if (deltaY != 0.0) {
            lastScreen = Vanilla.INSTANCE.screen();
            result = CommonForgeEventHandler.processVerticalScrollEvent(deltaY);
            result = CommonForgeEventHandler.processVerticalScrollGUIEvent(deltaY, event.getMouseX(), event.getMouseY()) || result;
            event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
        }
    }

    private static boolean processVerticalScrollGUIEvent(double delta, double mouseX, double mouseY) {
        int button = delta > 0.0 ? -10000 : -10001;
        boolean result = GlobalScreenEventListener.INSTANCE.onMouseClicked(mouseX, mouseY, button, true);
        result = GlobalScreenEventListener.INSTANCE.onMouseReleased(mouseX, mouseY, button, true) || result;
        return result;
    }

    private static boolean processHorizontalScrollGUIEvent(double delta, double mouseX, double mouseY) {
        int button = delta > 0.0 ? -10002 : -10003;
        boolean result = GlobalScreenEventListener.INSTANCE.onMouseClicked(mouseX, mouseY, button, true);
        result = GlobalScreenEventListener.INSTANCE.onMouseReleased(mouseX, mouseY, button, true) || result;
        return result;
    }

    private static boolean processVerticalScrollEvent(double delta) {
        int button = delta > 0.0 ? -10000 : -10001;
        boolean result = GlobalInputHandler.INSTANCE.onMouseButton(button, 1, 0);
        result = GlobalInputHandler.INSTANCE.onMouseButton(button, 0, 0) | result;
        return result;
    }

    private static boolean processHorizontalScrollEvent(double delta) {
        int button = delta > 0.0 ? -10002 : -10003;
        boolean result = GlobalInputHandler.INSTANCE.onMouseButton(button, 1, 0);
        result = GlobalInputHandler.INSTANCE.onMouseButton(button, 0, 0) | result;
        return result;
    }
}

