/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class PageFlipButton
extends Button {
    private static final ResourceLocation texture = ResourceLocation.tryBuild((String)"solonion", (String)"textures/gui/food_book.png");
    public static final int width = 23;
    public static final int height = 13;
    private final Direction direction;
    private final Pageable pageable;

    public PageFlipButton(int x, int y, Direction direction, Pageable pageable) {
        super(x, y, 23, 13, (Component)Component.literal((String)""), button -> ((PageFlipButton)button).changePage(), Button.DEFAULT_NARRATION);
        this.direction = direction;
        this.pageable = pageable;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean isHovered;
        if (!this.visible) {
            return;
        }
        int textureX = 0;
        boolean bl = isHovered = this.getX() <= mouseX && mouseX < this.getX() + 23 && this.getY() <= mouseY && mouseY < this.getY() + 13;
        if (isHovered) {
            textureX += 23;
        }
        int textureY = this.direction == Direction.FORWARD ? 192 : 205;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        graphics.blit(texture, this.getX(), this.getY(), textureX, textureY, 23, 13);
    }

    public void updateState() {
        this.visible = this.pageable.isWithinRange(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    private void changePage() {
        this.pageable.switchToPage(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    public void playDownSound(SoundManager soundManager) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
    }

    public static enum Direction {
        FORWARD(1),
        BACKWARD(-1);

        final int distance;

        private Direction(int distance) {
            this.distance = distance;
        }
    }

    public static interface Pageable {
        public void switchToPage(int var1);

        public int getCurrentPageNumber();

        public boolean isWithinRange(int var1);
    }
}

