/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.client.SOLOnionClient;
import team.creative.solonion.common.SOLOnionConfig;
import team.creative.solonion.common.command.FoodListCommand;
import team.creative.solonion.common.event.SOLOnionEvent;
import team.creative.solonion.common.item.SOLOnionItems;
import team.creative.solonion.common.item.foodcontainer.FoodContainerItem;
import team.creative.solonion.common.network.FoodListMessage;

@Mod(value="solonion")
public final class SOLOnion {
    public static final String MODID = "solonion";
    public static final Logger LOGGER = LogManager.getLogger((String)"solonion");
    public static CreativeNetwork NETWORK = new CreativeNetwork(1, LOGGER, ResourceLocation.tryBuild((String)"solonion", (String)"main"));
    public static SOLOnionConfig CONFIG;
    public static SOLOnionEvent EVENT;

    public static boolean isActive(Player player) {
        return !SOLOnion.CONFIG.limitProgressionToSurvival || PlayerUtils.getGameType((Player)player).isSurvival();
    }

    public SOLOnion(IEventBus bus) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            SOLOnionClient.load(bus);
        }
        bus.addListener(this::setup);
        bus.addListener(this::registerCapabilities);
        SOLOnionItems.ITEMS.register(bus);
        SOLOnionItems.MENU_TYPES.register(bus);
        bus.addListener(SOLOnionItems::registerTabs);
        NeoForge.EVENT_BUS.addListener(this::command);
        SOLOnionAPI.ATTACHMENT_TYPES.register(bus);
    }

    public void setup(FMLCommonSetupEvent event) {
        NETWORK.registerType(FoodListMessage.class, FoodListMessage::new);
        EVENT = new SOLOnionEvent();
        NeoForge.EVENT_BUS.register((Object)EVENT);
        CONFIG = new SOLOnionConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (itemStack, context) -> {
            ItemStackHandler handler = new ItemStackHandler(((FoodContainerItem)itemStack.getItem()).nslots);
            if (itemStack.has(DataComponents.CONTAINER)) {
                ItemContainerContents container = (ItemContainerContents)itemStack.get(DataComponents.CONTAINER);
                for (int i = 0; i < handler.getSlots() && container.getSlots() > i; ++i) {
                    handler.setStackInSlot(i, container.getStackInSlot(i));
                }
            }
            return handler;
        }, new ItemLike[]{(ItemLike)SOLOnionItems.LUNCHBOX.get(), (ItemLike)SOLOnionItems.LUNCHBAG.get(), (ItemLike)SOLOnionItems.GOLDEN_LUNCHBOX.get()});
    }

    public void command(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MODID).then(FoodListCommand.withPlayerArgumentOrSender(Commands.literal((String)"sync"), FoodListCommand::syncFoodList))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.literal((String)"clear"), FoodListCommand::clearFoodList))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.literal((String)"diversity"), FoodListCommand::displayDiversity))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.literal((String)"resetOrigin"), FoodListCommand::resetPlayerOrigin))).then(FoodListCommand.withNoArgument(Commands.literal((String)"resetAllOrigins"), FoodListCommand::resetAllOrigins)));
    }
}

