/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.event;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.solonion.api.FoodPlayerData;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.benefit.BenefitPlayerDataImpl;
import team.creative.solonion.common.benefit.BenefitStack;
import team.creative.solonion.common.benefit.BenefitThreshold;
import team.creative.solonion.common.food.FoodPlayerDataImpl;
import team.creative.solonion.common.item.foodcontainer.FoodContainerItem;
import team.creative.solonion.common.network.FoodListMessage;

public class SOLOnionEvent {
    public void updatePlayerBenefits(Player player) {
        if (!SOLOnion.isActive(player) || !player.isAlive()) {
            return;
        }
        this.updateBenefits(player);
    }

    private void updateBenefits(Player player) {
        if (player.getCommandSenderWorld().isClientSide) {
            return;
        }
        FoodPlayerData foodList = SOLOnionAPI.getFoodCapability(player);
        if (foodList.trackCount() < SOLOnion.CONFIG.minFoodsToActivate) {
            return;
        }
        BenefitStack stack = new BenefitStack();
        double d = foodList.foodDiversity((LivingEntity)player);
        for (BenefitThreshold threshold : SOLOnion.CONFIG.benefits) {
            if (!(threshold.threshold <= d)) break;
            stack.add(threshold.benefit);
        }
        for (BenefitThreshold threshold : SOLOnion.CONFIG.detriments) {
            if (!(threshold.threshold > d)) break;
            stack.add(threshold.benefit);
        }
        SOLOnionAPI.getBenefitCapability(player).updateStack(player, stack);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.updatePlayerBenefits(event.getEntity());
        this.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && SOLOnion.CONFIG.resetOnDeath) {
            return;
        }
        Player originalPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        RegistryAccess provider = newPlayer.registryAccess();
        FoodPlayerDataImpl food = new FoodPlayerDataImpl();
        food.deserializeNBT((HolderLookup.Provider)provider, (ListTag)SOLOnionAPI.getFoodCapability(originalPlayer).serializeNBT((HolderLookup.Provider)provider));
        newPlayer.setData(SOLOnionAPI.FOOD_DATA, (Object)food);
        BenefitPlayerDataImpl benefit = new BenefitPlayerDataImpl();
        benefit.deserializeNBT((HolderLookup.Provider)provider, (CompoundTag)SOLOnionAPI.getBenefitCapability(originalPlayer).serializeNBT((HolderLookup.Provider)provider));
        newPlayer.setData(SOLOnionAPI.BENEFIT_DATA, (Object)benefit);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.updatePlayerBenefits(event.getEntity());
        this.syncFoodList(event.getEntity());
    }

    public void syncFoodList(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        SOLOnion.NETWORK.sendToClient((CreativePacket)new FoodListMessage((HolderLookup.Provider)player.registryAccess(), SOLOnionAPI.getFoodCapability(player)), (ServerPlayer)player);
    }

    @SubscribeEvent
    public void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!SOLOnion.isActive(player)) {
            return;
        }
        ItemStack usedItem = event.getItem();
        if (usedItem.getFoodProperties((LivingEntity)player) == null && usedItem.getItem() != Items.CAKE) {
            return;
        }
        if (usedItem.getItem() instanceof FoodContainerItem) {
            return;
        }
        this.eat(usedItem, player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCakeBlockEaten(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        BlockState state = event.getLevel().getBlockState(event.getPos());
        Block clickedBlock = state.getBlock();
        Player player = event.getEntity();
        Item eatenItem = Items.CAKE;
        if (ModList.get().isLoaded("farmersdelight")) {
            eatenItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryBuild((String)"farmersdelight", (String)"cake_slice"));
        }
        ItemStack eatenItemStack = new ItemStack((ItemLike)eatenItem);
        if (clickedBlock == Blocks.CAKE && player.canEat(false) && event.getHand() == InteractionHand.MAIN_HAND && !event.getLevel().isClientSide) {
            EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)eatenItemStack, (int)0, (ItemStack)ItemStack.EMPTY);
        }
    }

    public void eat(ItemStack food, Player player) {
        FoodPlayerData foodList = SOLOnionAPI.getFoodCapability(player);
        foodList.eat((LivingEntity)player, food);
        this.updatePlayerBenefits(player);
        this.syncFoodList(player);
    }
}

