/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape;

import com.google.common.reflect.Reflection;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.compat.EnderscapeTerrablender;
import net.bunten.enderscape.datagen.EnderscapeBiomeModifiers;
import net.bunten.enderscape.registry.EnderscapeBiomeSounds;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeCreativeModeTab;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataAttachments;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeDensityFunctionTypes;
import net.bunten.enderscape.registry.EnderscapeEnchantmentEffectComponents;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.EnderscapeFeatures;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeMobEffects;
import net.bunten.enderscape.registry.EnderscapeModifications;
import net.bunten.enderscape.registry.EnderscapeMusic;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.EnderscapePoi;
import net.bunten.enderscape.registry.EnderscapePotions;
import net.bunten.enderscape.registry.EnderscapeServerNetworking;
import net.bunten.enderscape.registry.EnderscapeSoundTypeOverrides;
import net.bunten.enderscape.registry.EnderscapeSoundTypes;
import net.bunten.enderscape.registry.EnderscapeStats;
import net.bunten.enderscape.registry.EnderscapeStructureMusic;
import net.bunten.enderscape.registry.EnderscapeSubEntityPredicates;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enderscape")
public class Enderscape {
    public static final String MOD_ID = "enderscape";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean IS_DEBUG = !FMLLoader.isProduction();
    public static final ResourceKey<Structure> END_CITY_RESOURCE_KEY = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Enderscape.id("end_city"));

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static SoundEvent registerSoundEvent(String name) {
        ResourceLocation id = Enderscape.id(name);
        SoundEvent soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)id);
        RegistryHelper.register(BuiltInRegistries.SOUND_EVENT, id, () -> soundEvent);
        return soundEvent;
    }

    public static Holder<SoundEvent> registerSoundEventHolder(String name) {
        ResourceLocation location = Enderscape.id(name);
        return RegistryHelper.registerForHolder(BuiltInRegistries.SOUND_EVENT, location, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)location));
    }

    public Enderscape(IEventBus modBus, ModContainer modContainer) {
        Reflection.initialize((Class[])new Class[]{EnderscapeConfig.class, EnderscapeItems.class, EnderscapeBlocks.class, EnderscapeFeatures.class, EnderscapeBlockEntities.class, EnderscapeBiomeSounds.class, EnderscapeBlockSounds.class, EnderscapeEntitySounds.class, EnderscapeItemSounds.class, EnderscapeMusic.class, EnderscapeSoundTypes.class, EnderscapePoi.class, EnderscapeParticles.class, EnderscapeEnchantmentEffectComponents.class, EnderscapeMobEffects.class, EnderscapeEntities.class, EnderscapeSubEntityPredicates.class, EnderscapeStats.class, EnderscapeCriteria.class, EnderscapePotions.class, EnderscapeServerNetworking.class, EnderscapeModifications.class, EnderscapeSoundTypeOverrides.class, EnderscapeCreativeModeTab.class, EnderscapeDataComponents.class, EnderscapeDensityFunctionTypes.class, EnderscapeStructureMusic.class, EnderscapeBiomeModifiers.class, EnderscapeDataAttachments.class});
        if (ModList.get().isLoaded("terrablender")) {
            EnderscapeTerrablender.initialize();
        }
        modBus.addListener(AddPackFindersEvent.class, event -> {
            this.registerClientResourcePack((AddPackFindersEvent)event, Enderscape.id("fix_levitation_advancement"), (Component)Component.translatable((String)"pack.enderscape.fix_levitation_advancement"));
            this.registerClientResourcePack((AddPackFindersEvent)event, Enderscape.id("fix_vanilla_recipes"), (Component)Component.translatable((String)"pack.enderscape.fix_vanilla_recipes"));
            this.registerClientResourcePack((AddPackFindersEvent)event, Enderscape.id("new_end_cities"), (Component)Component.translatable((String)"pack.enderscape.new_end_cities"));
            this.registerClientResourcePack((AddPackFindersEvent)event, Enderscape.id("new_terrain"), (Component)Component.translatable((String)"pack.enderscape.new_terrain"));
        });
        LOGGER.info("Enderscape initialized!");
    }

    private void registerClientResourcePack(AddPackFindersEvent event, ResourceLocation id, Component name) {
        event.addPackFinders(id.withPrefix("resourcepacks/"), PackType.SERVER_DATA, name, PackSource.DEFAULT, false, Pack.Position.TOP);
    }
}

