/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.biome;

import net.bunten.enderscape.registry.EnderscapeBiomeSounds;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.EnderscapePlacedFeatures;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.EndPlacements;
import net.minecraft.sounds.Musics;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class VeiledWoodlandsBiome {
    public static Biome create(BootstrapContext<Biome> context) {
        HolderGetter features = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter carvers = context.lookup(Registries.CONFIGURED_CARVER);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)EnderscapeEntities.RUSTLE.get(), 20, 2, 3)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EnderscapeEntities.RUBBLEMITE.get(), 4, 2, 3));
        BiomeDefaultFeatures.endSpawns((MobSpawnSettings.Builder)spawns);
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(features, carvers).addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, EndPlacements.END_GATEWAY_RETURN).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, EnderscapePlacedFeatures.VOID_SHALE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, EnderscapePlacedFeatures.VOID_SHALE_BLOBS).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, EnderscapePlacedFeatures.VERADITE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, EnderscapePlacedFeatures.MIRESTONE_BLOBS).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, EnderscapePlacedFeatures.SHADOLINE_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, EnderscapePlacedFeatures.SCATTERED_SHADOLINE_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, EnderscapePlacedFeatures.NEBULITE_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, EnderscapePlacedFeatures.CEILING_NEBULITE_ORE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnderscapePlacedFeatures.UNCOMMON_CHORUS_PLANTS).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnderscapePlacedFeatures.UNCOMMON_CHORUS_SPROUTS).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnderscapePlacedFeatures.COMMON_DRY_END_GROWTH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnderscapePlacedFeatures.VEILED_TREES).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnderscapePlacedFeatures.VEILED_WOODLANDS_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnderscapePlacedFeatures.WISP_FLOWER_PATCHES).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnderscapePlacedFeatures.MURUBLIGHT_SHELF);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().skyColor(0x161621).fogColor(0x101017).waterColor(9872305).waterFogColor(4607321).foliageColorOverride(10597016).grassColorOverride(10597016).ambientParticle(new AmbientParticleSettings((ParticleOptions)EnderscapeParticles.VOID_STARS.get(), 0.003f)).ambientLoopSound(EnderscapeBiomeSounds.VEILED_WOODLANDS.loop()).ambientAdditionsSound(new AmbientAdditionsSettings(EnderscapeBiomeSounds.VEILED_WOODLANDS.additions(), 6.0E-4)).ambientMoodSound(new AmbientMoodSettings(EnderscapeBiomeSounds.VEILED_WOODLANDS.mood(), 6000, 8, 2.0)).backgroundMusic(Musics.createGameMusic(EnderscapeBiomeSounds.VEILED_WOODLANDS.music())).build()).mobSpawnSettings(spawns.build()).generationSettings(builder.build()).build();
    }
}

