/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.biome.modifications;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.registry.EnderscapeBiomeSounds;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.tag.EnderscapeBiomeTags;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.Music;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public final class ModifyEndAmbianceModification
implements BiomeModifier {
    public static final ModifyEndAmbianceModification INSTANCE = new ModifyEndAmbianceModification();
    public static final MapCodec<ModifyEndAmbianceModification> CODEC = MapCodec.unit((Object)INSTANCE);
    private static final EnderscapeConfig CONFIG = EnderscapeConfig.getInstance();

    private ModifyEndAmbianceModification() {
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (biome.is(EnderscapeBiomeTags.HAS_MODIFIED_END_AMBIENCE)) {
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultMusic) {
                builder.getSpecialEffects().backgroundMusic(new Music(EnderscapeBiomeSounds.DEFAULT_END.music(), 12000, 24000, false));
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultLoop) {
                builder.getSpecialEffects().ambientLoopSound(EnderscapeBiomeSounds.DEFAULT_END.loop());
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultAdditions) {
                builder.getSpecialEffects().ambientAdditionsSound(new AmbientAdditionsSettings(EnderscapeBiomeSounds.DEFAULT_END.additions(), 7.5E-4));
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultMood) {
                builder.getSpecialEffects().ambientMoodSound(new AmbientMoodSettings(EnderscapeBiomeSounds.DEFAULT_END.mood(), 6000, 8, 2.0));
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultParticles) {
                builder.getSpecialEffects().ambientParticle(new AmbientParticleSettings((ParticleOptions)EnderscapeParticles.VOID_STARS.get(), 0.003f));
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultSkyColor) {
                builder.getSpecialEffects().skyColor(1577761);
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultFogColor) {
                builder.getSpecialEffects().fogColor(1117464);
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultGrassColor) {
                builder.getSpecialEffects().grassColorOverride(10598275);
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultFoliageColor) {
                builder.getSpecialEffects().foliageColorOverride(10598275);
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultWaterColor) {
                builder.getSpecialEffects().waterColor(7961249);
            }
            if (ModifyEndAmbianceModification.CONFIG.ambienceUpdateDefaultWaterFogColor) {
                builder.getSpecialEffects().waterFogColor(3684693);
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

