/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.block.properties.Part;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.feature.GrowthConfig;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractGrowthBlock
extends DirectionalPlantBlock
implements BonemealableBlock {
    public static final EnumProperty<Part> GROWTH = StateProperties.GROWTH_PART;

    public AbstractGrowthBlock(DirectionProperties properties, BlockBehaviour.Properties settings) {
        super(properties, settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(GROWTH, (Comparable)((Object)Part.TOP)));
    }

    public static Part getPart(BlockState state) {
        return (Part)((Object)state.getValue(GROWTH));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GROWTH, FACING});
    }

    public boolean hasGrowthSupport(BlockState state, BlockState floor) {
        return floor.is((Block)this) && floor.getValue((Property)FACING) == state.getValue((Property)FACING);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int i = AbstractGrowthBlock.getPart(state) == Part.TOP ? 15 : 16;
        return BlockUtil.createRotatedShape(1.0, 0.0, 1.0, 15.0, i, 15.0, (Direction)state.getValue((Property)FACING));
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        Direction plantDirection = AbstractGrowthBlock.getFacing(state);
        Direction opposite = plantDirection.getOpposite();
        if (opposite == direction && !state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        BlockState up = world.getBlockState(pos.relative(plantDirection));
        BlockState down = world.getBlockState(pos.relative(opposite));
        if (down.is((Block)this)) {
            return (BlockState)state.setValue(GROWTH, (Comparable)((Object)(up.is((Block)this) && AbstractGrowthBlock.getFacing(up) == plantDirection ? Part.MIDDLE : Part.TOP)));
        }
        return (BlockState)state.setValue(GROWTH, (Comparable)((Object)(up.is((Block)this) && AbstractGrowthBlock.getFacing(up) == plantDirection ? Part.BOTTOM : Part.TOP)));
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos origin, BlockState state) {
        return AbstractGrowthBlock.getPart(state) == Part.TOP && world.getBlockState(origin.relative(AbstractGrowthBlock.getFacing(state))).isAir();
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos origin, BlockState state) {
        world.setBlockAndUpdate(origin.relative(AbstractGrowthBlock.getFacing(state)), state);
    }

    public static void generatePatch(ServerLevel world, RandomSource random, BlockPos origin, BlockState state, int range, int i, int max) {
        for (BlockPos pos : BlockPos.randomInCube((RandomSource)random, (int)30, (BlockPos)origin, (int)range)) {
            if (i >= max) break;
            Direction direction = AbstractGrowthBlock.getFacing(state);
            BlockPos offset = pos.relative(direction);
            if (world.getBlockState(pos).is(state.getBlock()) || !world.isEmptyBlock(offset) || !state.canSurvive((LevelReader)world, offset)) continue;
            AbstractGrowthBlock.generate((LevelAccessor)world, offset, random, new GrowthConfig(state, (IntProvider)ConstantInt.of((int)1), (IntProvider)UniformInt.of((int)1, (int)2), 0.5f));
            ++i;
        }
    }

    public static boolean generate(LevelAccessor world, BlockPos origin, RandomSource random, GrowthConfig config) {
        BlockState state = config.state();
        Direction direction = (Direction)state.getValue((Property)FACING);
        int totalHeight = config.base_height().sample(random) + (random.nextFloat() <= config.added_height_chance() ? config.added_height().sample(random) : 0);
        BlockPos.MutableBlockPos mutable = origin.mutable();
        for (int i = 0; totalHeight > i; ++i) {
            Part part = i == totalHeight - 1 ? Part.TOP : (i == 0 ? Part.BOTTOM : Part.MIDDLE);
            BlockUtil.replace(world, (BlockPos)mutable, (BlockState)state.setValue(StateProperties.GROWTH_PART, (Comparable)((Object)part)));
            mutable.move(direction);
        }
        return true;
    }
}

