/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOvergrowthBlock
extends DirectionalBlock
implements BonemealableBlock {
    protected final boolean needsAir;
    @Nullable
    protected final Block pathBlock;
    protected final Block baseBlock;
    public final SoundEvent flattenSound;
    protected final boolean isPath;
    protected final DirectionProperties properties;
    protected int horizontalBonemealRange = 8;

    public AbstractOvergrowthBlock(boolean needsAir, Block baseBlock, @Nullable Block pathBlock, @Nullable SoundEvent flattenSound, boolean isPath, DirectionProperties properties, BlockBehaviour.Properties settings) {
        super(settings);
        this.needsAir = needsAir;
        this.baseBlock = baseBlock;
        this.pathBlock = pathBlock;
        this.flattenSound = flattenSound;
        this.isPath = isPath;
        this.properties = properties;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public AbstractOvergrowthBlock(boolean needsAir, Block baseBlock, @Nullable Block pathBlock, @Nullable SoundEvent flattenSound, DirectionProperties properties, BlockBehaviour.Properties settings) {
        this(needsAir, baseBlock, pathBlock, flattenSound, false, properties, settings);
    }

    public AbstractOvergrowthBlock(boolean needsAir, Block baseBlock, DirectionProperties properties, BlockBehaviour.Properties settings) {
        this(needsAir, baseBlock, null, null, true, properties, settings);
    }

    public static Direction getDirection(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction dir = context.getNearestLookingDirection().getOpposite();
        if (!this.properties.supports(dir)) {
            dir = Direction.UP;
        }
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir);
        if (this.isPath && !this.hasAir(state, (LevelReader)context.getLevel(), context.getClickedPos())) {
            return Block.pushEntitiesUp((BlockState)state, (BlockState)this.baseBlock.defaultBlockState(), (LevelAccessor)context.getLevel(), (BlockPos)context.getClickedPos());
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.GROWER;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.needsAir && !this.hasAir(state, (LevelReader)level, pos)) {
            BlockState state2 = AbstractOvergrowthBlock.pushEntitiesUp((BlockState)state, (BlockState)this.baseBlock.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos);
            level.setBlockAndUpdate(pos, state2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(null, (BlockState)state2));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player mob, InteractionHand hand, BlockHitResult result) {
        if (this.pathBlock != null && stack.getItem() instanceof ShovelItem && world.getBlockState(pos.relative((Direction)state.getValue((Property)FACING))).isAir()) {
            world.playSound(mob, pos, this.flattenSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.isClientSide()) {
                world.setBlock(pos, (BlockState)this.pathBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
                stack.hurtAndBreak(1, (LivingEntity)mob, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return !this.isPath && world.getBlockState(pos.relative(AbstractOvergrowthBlock.getDirection(state))).propagatesSkylightDown((BlockGetter)world, pos.relative(AbstractOvergrowthBlock.getDirection(state)));
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return !this.isPath;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int range = this.horizontalBonemealRange / 2;
        level.setBlock(pos, state, 2);
        Direction dir = (Direction)state.getValue((Property)FACING);
        for (int x = -range + 1; x < range; ++x) {
            for (int y = -12; y < 12; ++y) {
                for (int z = -range + 1; z < range; ++z) {
                    boolean bl;
                    BlockPos pos2 = pos.offset(x, y, z);
                    BlockPos relative = pos2.relative(dir);
                    boolean bl2 = bl = level.getBlockState(relative).propagatesSkylightDown((BlockGetter)level, relative) && level.getBlockState(pos2).is(this.baseBlock);
                    if (!bl || !(Mth.sqrt((float)(x * x + y * y + z * z)) <= (float)range) || !(level.getRandom().nextFloat() < 0.6f)) continue;
                    level.setBlock(pos2, state, 2);
                }
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!this.isPath) {
            return super.getShape(state, world, pos, context);
        }
        return BlockUtil.createRotatedShape(0.0, 0.0, 0.0, 16.0, 15.0, 16.0, (Direction)state.getValue((Property)FACING));
    }

    public boolean hasAir(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos relative = pos.relative(facing);
        BlockState relativeState = level.getBlockState(relative);
        if (this.isPath) {
            return !relativeState.isSolid() || relativeState.getBlock() instanceof FenceGateBlock;
        }
        return LightEngine.getLightBlockInto((BlockGetter)level, (BlockState)state, (BlockPos)pos, (BlockState)relativeState, (BlockPos)relative, (Direction)facing, (int)relativeState.getLightBlock((BlockGetter)level, relative)) < 15;
    }

    protected boolean useShapeForLightOcclusion(BlockState blockState) {
        return this.isPath;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (direction == state.getValue((Property)FACING) && !this.hasAir(state, (LevelReader)world, pos) && this.isPath && this.needsAir) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, state2, world, pos, pos2);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState state2 = AbstractOvergrowthBlock.pushEntitiesUp((BlockState)state, (BlockState)this.baseBlock.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos);
        level.setBlockAndUpdate(pos, state2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(null, (BlockState)state2));
    }
}

