/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.properties.StateProperties;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVineBlock
extends Block {
    public static final BooleanProperty ATTACHED = StateProperties.ATTACHED;
    public static final IntegerProperty AGE = StateProperties.AGE_15;
    public static final int MAX_AGE = 15;

    public AbstractVineBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    abstract TagKey<Block> getPreferredBlocks();

    protected static boolean getAttached(BlockState state) {
        return (Boolean)state.getValue((Property)ATTACHED);
    }

    protected static boolean isBody(BlockState state) {
        return AbstractVineBlock.getAttached(state);
    }

    protected static int getAge(BlockState state) {
        return (Integer)state.getValue((Property)AGE);
    }

    protected static int getPlacementAge(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)1, (int)9);
    }

    protected void growVine(ServerLevel world, RandomSource random, BlockPos pos, BlockState state, float cycleChance) {
        BlockState down = (BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false));
        BlockState vine = (BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true));
        if (random.nextFloat() <= cycleChance && AbstractVineBlock.getAge(state) < 15) {
            down = (BlockState)down.cycle((Property)AGE);
            vine = (BlockState)vine.cycle((Property)AGE);
        }
        world.setBlockAndUpdate(pos.below(), down);
        world.setBlockAndUpdate(pos, vine);
    }

    protected BlockState state(BlockState state, boolean attached, int age) {
        return (BlockState)((BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(attached))).setValue((Property)AGE, (Comparable)Integer.valueOf(age));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos().below());
        return state.is((Block)this) ? this.defaultBlockState() : (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(AbstractVineBlock.getPlacementAge(context.getLevel().getRandom())));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        if (AbstractVineBlock.getAttached(state)) {
            return AbstractVineBlock.box((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)16.0, (double)13.5);
        }
        return AbstractVineBlock.box((double)2.5, (double)2.5, (double)2.5, (double)13.5, (double)16.0, (double)13.5);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState down = world.getBlockState(pos.below());
        return down.is((Block)this) ? this.state(state, true, (Integer)down.getValue((Property)AGE)) : this.state(state, false, AbstractVineBlock.getAge(state));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState above = world.getBlockState(pos.above());
        return world.getFluidState(pos).isEmpty() && (above.is((Block)this) || above.isFaceSturdy((BlockGetter)world, pos, Direction.DOWN) && above.is(this.getPreferredBlocks()));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.AIR && !this.hasCollision || super.isPathfindable(state, type);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (stack.getItem() instanceof ShearsItem && AbstractVineBlock.getAge(state) < 15 && !AbstractVineBlock.getAttached(state)) {
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            if (player instanceof ServerPlayer) {
                ServerPlayer server = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(server, pos, stack);
            }
            level.playSound(player, pos, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(pos, this.state(state, false, 15));
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

