/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlinklampBlock
extends Block {
    public static final IntegerProperty LUMINANCE = IntegerProperty.create((String)"luminance", (int)0, (int)15);

    public BlinklampBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> BlinklampBlock.getLuminance(state)));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LUMINANCE, (Comparable)Integer.valueOf(4)));
    }

    public static int getLuminance(BlockState state) {
        return (Integer)state.getValue((Property)LUMINANCE);
    }

    private int findLuminance(Level world, BlockPos pos) {
        return 15 - world.getBestNeighborSignal(pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LUMINANCE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LUMINANCE, (Comparable)Integer.valueOf(this.findLuminance(context.getLevel(), context.getClickedPos())));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos blockPos2, boolean bl) {
        int luminance;
        if (!level.isClientSide() && (luminance = this.findLuminance(level, pos)) != BlinklampBlock.getLuminance(state)) {
            level.scheduleTick(pos, (Block)this, 5);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int luminance = this.findLuminance((Level)world, pos);
        SoundEvent sound = luminance > BlinklampBlock.getLuminance(state) ? EnderscapeBlockSounds.BLINKLAMP_INCREASE : EnderscapeBlockSounds.BLINKLAMP_DECREASE;
        world.setBlock(pos, (BlockState)state.setValue((Property)LUMINANCE, (Comparable)Integer.valueOf(luminance)), 3);
        world.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

