/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.BlinklightVinesBodyBlock;
import net.bunten.enderscape.block.BlinklightVinesHeadBlock;
import net.bunten.enderscape.block.properties.StateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface BlinklightVines {
    public static final DustColorTransitionOptions BLINKLIGHT_TO_REDSTONE = new DustColorTransitionOptions(Vec3.fromRGB24((int)15182079).toVector3f(), Vec3.fromRGB24((int)0xFF0000).toVector3f(), 1.0f);
    public static final IntegerProperty BODY_STAGE = StateProperties.BLINKLIGHT_BODY_STAGE;
    public static final IntegerProperty HEAD_STAGE = StateProperties.BLINKLIGHT_HEAD_STAGE;
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public int getStageDuration(BlockState var1);

    public void playBlinkEffects(BlockState var1, ServerLevel var2, BlockPos var3, RandomSource var4);

    public IntegerProperty getStageProperty();

    public static int getLuminance(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof BlinklightVinesHeadBlock) {
            BlinklightVinesHeadBlock head = (BlinklightVinesHeadBlock)block;
            switch (head.getStage(state)) {
                case 0: {
                    return 15;
                }
                case 1: 
                case 5: {
                    return 13;
                }
                case 2: 
                case 4: {
                    return 11;
                }
                case 3: {
                    return 9;
                }
            }
        }
        if ((block = state.getBlock()) instanceof BlinklightVinesBodyBlock) {
            BlinklightVinesBodyBlock body = (BlinklightVinesBodyBlock)block;
            switch (body.getStage(state)) {
                case 0: {
                    return 6;
                }
                case 1: 
                case 2: {
                    return 4;
                }
            }
        }
        return 0;
    }

    default public int getStage(BlockState state) {
        return (Integer)state.getValue((Property)this.getStageProperty());
    }

    default public boolean isOpen(BlockState state) {
        return this.getStage(state) == 0;
    }

    default public boolean isClosed(BlockState state) {
        return this.getStage(state) == 3;
    }

    default public void close(BlockState state, ServerLevel world, BlockPos pos) {
        state = (BlockState)state.cycle((Property)this.getStageProperty());
        world.setBlockAndUpdate(pos, state);
        this.playBlinkEffects(state, world, pos, world.getRandom());
        if (!this.isOpen(state)) {
            world.scheduleTick(pos, state.getBlock(), this.getStageDuration(state));
        }
    }
}

