/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.bunten.enderscape.block.BlinklightVines;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlinklightVinesBodyBlock
extends GrowingPlantBodyBlock
implements BlinklightVines {
    public static final MapCodec<BlinklightVinesBodyBlock> CODEC = BlinklightVinesBodyBlock.simpleCodec(BlinklightVinesBodyBlock::new);

    public BlinklightVinesBodyBlock(BlockBehaviour.Properties settings) {
        super(settings, Direction.DOWN, SHAPE, false);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getStageProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    public IntegerProperty getStageProperty() {
        return BODY_STAGE;
    }

    @Override
    public int getStageDuration(BlockState state) {
        return 6;
    }

    @Override
    public void playBlinkEffects(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        Optional head = BlockUtil.getTopConnectedBlock((BlockGetter)world, (BlockPos)pos, (Block)state.getBlock(), (Direction)this.growthDirection, (Block)this.getHeadBlock());
        if (head.isPresent()) {
            BlinklightVines vines;
            BlockPos headPos = (BlockPos)head.get();
            GrowingPlantHeadBlock growingPlantHeadBlock = this.getHeadBlock();
            return growingPlantHeadBlock instanceof BlinklightVines && (vines = (BlinklightVines)growingPlantHeadBlock).isOpen(world.getBlockState(headPos)) && world.getBlockState(headPos.relative(this.growthDirection)).isAir();
        }
        return false;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextInt(24) == 0 && this.isOpen(state)) {
            this.close(state, world, pos);
        }
        super.randomTick(state, world, pos, random);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
            return;
        }
        state = (BlockState)state.cycle((Property)this.getStageProperty());
        world.setBlock(pos, state, 3);
        this.playBlinkEffects(state, world, pos, random);
        if (this.getStage(state) > 0) {
            world.scheduleTick(pos, (Block)this, this.getStageDuration(state));
        }
    }

    protected MapCodec<? extends GrowingPlantBodyBlock> codec() {
        return CODEC;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (!this.isOpen(state) && direction == this.growthDirection.getOpposite() && !state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, state2, world, pos, pos2);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return this.isClosed(state) ? 6 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getStageProperty()});
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)EnderscapeItems.BLINKLIGHT.get());
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)EnderscapeBlocks.BLINKLIGHT_VINES_HEAD.get();
    }

    public void animateTick(BlockState state, Level world, BlockPos origin, RandomSource random) {
        if (random.nextFloat() < 0.9f) {
            return;
        }
        world.addParticle((ParticleOptions)EnderscapeParticles.BLINKLIGHT_SPORES.get(), (double)origin.getX() + random.nextDouble(), (double)origin.getY() + random.nextDouble(), (double)origin.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
    }
}

