/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.BlinklightVines;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class BlinklightVinesHeadBlock
extends GrowingPlantHeadBlock
implements BlinklightVines {
    public static final MapCodec<BlinklightVinesHeadBlock> CODEC = BlinklightVinesHeadBlock.simpleCodec(BlinklightVinesHeadBlock::new);

    public BlinklightVinesHeadBlock(BlockBehaviour.Properties settings) {
        super(settings, Direction.DOWN, SHAPE, false, 0.14);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)this.getStageProperty(), (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<BlinklightVinesHeadBlock> codec() {
        return CODEC;
    }

    @Override
    public IntegerProperty getStageProperty() {
        return HEAD_STAGE;
    }

    @Override
    public int getStageDuration(BlockState state) {
        return this.isClosed(state) ? 30 : 4;
    }

    @Override
    public void playBlinkEffects(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.isOpen(state)) {
            SoundEvent sound = EnderscapeBlockSounds.BLINKLIGHT_VINES_INBETWEEN;
            if (this.isClosed(state)) {
                sound = EnderscapeBlockSounds.BLINKLIGHT_VINES_BLINK;
                level.gameEvent((Holder)GameEvent.BLOCK_CLOSE, pos, GameEvent.Context.of((BlockState)state));
                for (int i = 0; i < 4; ++i) {
                    level.sendParticles((ParticleOptions)BLINKLIGHT_TO_REDSTONE, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble() * 0.3 + 0.13, (double)pos.getZ() + random.nextDouble(), Mth.nextInt((RandomSource)random, (int)3, (int)6), 0.0, 0.0, 0.0, 0.0);
                }
            }
            level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result) {
        if (!this.isOpen(state)) {
            return InteractionResult.CONSUME;
        }
        if (this.isMaxAge(state)) {
            if (world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                this.close(state, server, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, result);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextInt(3) == 0 && this.isOpen(state) && this.isMaxAge(state)) {
            this.close(state, world, pos);
            return;
        }
        super.randomTick(state, world, pos, random);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
            return;
        }
        this.close(state, world, pos);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (!this.isOpen(state) && direction == this.growthDirection.getOpposite() && !state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, state2, world, pos, pos2);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return this.isClosed(state) ? 15 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getStageProperty()});
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)EnderscapeItems.BLINKLIGHT.get());
    }

    protected Block getBodyBlock() {
        return EnderscapeBlocks.BLINKLIGHT_VINES_BODY.get();
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return 1;
    }

    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    protected BlockState getGrowIntoState(BlockState state, RandomSource random) {
        return (BlockState)super.getGrowIntoState(state, random).setValue((Property)this.getStageProperty(), (Comparable)Integer.valueOf(0));
    }

    public void animateTick(BlockState state, Level world, BlockPos origin, RandomSource random) {
        BlockPos pos;
        if (random.nextFloat() > 0.65f && !world.getBlockState(pos = BlockUtil.random(origin, random, 3, 3, 3)).isCollisionShapeFullBlock((BlockGetter)world, pos)) {
            world.addParticle((ParticleOptions)EnderscapeParticles.BLINKLIGHT_SPORES.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }
}

