/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChorusCakeRollBlock
extends Block {
    public static final MapCodec<ChorusCakeRollBlock> CODEC = ChorusCakeRollBlock.simpleCodec(ChorusCakeRollBlock::new);
    public static final IntegerProperty BITES = StateProperties.BITES;
    public static final EnumProperty<Direction> FACING = StateProperties.HORIZONTAL_FACING;

    public MapCodec<ChorusCakeRollBlock> codec() {
        return CODEC;
    }

    public ChorusCakeRollBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shorten = (Integer)state.getValue((Property)BITES) * 2;
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> ChorusCakeRollBlock.box((double)4.0, (double)0.0, (double)(1 + shorten), (double)12.0, (double)7.0, (double)15.0);
            case Direction.WEST -> ChorusCakeRollBlock.box((double)(1 + shorten), (double)0.0, (double)4.0, (double)15.0, (double)7.0, (double)12.0);
            case Direction.EAST -> ChorusCakeRollBlock.box((double)1.0, (double)0.0, (double)4.0, (double)(15 - shorten), (double)7.0, (double)12.0);
            case Direction.SOUTH -> ChorusCakeRollBlock.box((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)7.0, (double)(15 - shorten));
            default -> Shapes.empty();
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide()) {
            if (ChorusCakeRollBlock.eat((LevelAccessor)level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return ChorusCakeRollBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected static InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        if (player.canEat(false)) {
            if (level.isClientSide()) {
                ChorusCakeRollBlock.makeEatingParticles(level, state, player);
            }
            player.getFoodData().eat(2, 0.1f);
            player.playSound(EnderscapeBlockSounds.CHORUS_CAKE_ROLL_EAT, 1.0f, 1.0f);
            player.awardStat(Stats.EAT_CAKE_SLICE);
            level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
            int bites = (Integer)state.getValue((Property)BITES);
            if (bites < 6) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            } else {
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    ChorusCakeRollBlock.teleportEntityRandomly(server, (LivingEntity)player);
                }
                level.destroyBlock(pos, false);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void makeEatingParticles(LevelAccessor level, BlockState state, Player player) {
        for (int i = 0; i < 8; ++i) {
            RandomSource random = level.getRandom();
            double offsetY = (double)(-random.nextFloat()) * 0.6 - 0.3;
            Vec3 position = new Vec3(((double)random.nextFloat() - 0.5) * 0.3, offsetY, 0.6).xRot(-player.getXRot() * ((float)Math.PI / 180)).yRot(-player.getYRot() * ((float)Math.PI / 180)).add(player.getX(), player.getEyeY(), player.getZ());
            Vec3 velocity = new Vec3(((double)random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).xRot(-player.getXRot() * ((float)Math.PI / 180)).yRot(-player.getYRot() * ((float)Math.PI / 180));
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), position.x, position.y, position.z, velocity.x, velocity.y + 0.05, velocity.z);
        }
    }

    private static boolean teleportEntityRandomly(ServerLevel level, LivingEntity entity) {
        for (int i = 0; i < 16; ++i) {
            double x = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 16.0;
            double y = Mth.clamp((double)(entity.getY() + (entity.getRandom().nextDouble() - 0.5) * 16.0), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + level.getLogicalHeight() - 1));
            double z = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 16.0;
            if (entity.isPassenger()) {
                entity.stopRiding();
            }
            Vec3 previousPosition = entity.position();
            if (!entity.randomTeleport(x, y, z, true)) continue;
            level.gameEvent((Holder)GameEvent.TELEPORT, previousPosition, GameEvent.Context.of((Entity)entity));
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, entity instanceof Player ? SoundSource.PLAYERS : SoundSource.NEUTRAL);
            entity.resetFallDistance();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.resetCurrentImpulseContext();
            }
            return true;
        }
        return false;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor level, BlockPos pos, BlockPos pos2) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, state2, level, pos, pos2);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES, FACING});
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return ChorusCakeRollBlock.getOutputSignal((Integer)state.getValue((Property)BITES));
    }

    public static int getOutputSignal(int i) {
        return (7 - i) * 2;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

