/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChorusSproutsBlock
extends DirectionalPlantBlock
implements BonemealableBlock {
    public static final MapCodec<ChorusSproutsBlock> CODEC = ChorusSproutsBlock.simpleCodec(ChorusSproutsBlock::new);

    public ChorusSproutsBlock(BlockBehaviour.Properties settings) {
        super(DirectionProperties.create().up(), settings);
    }

    public MapCodec<ChorusSproutsBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean canPlantOn(BlockState state, BlockState floor, BlockGetter level, BlockPos pos, Direction facing) {
        return floor.is(EnderscapeBlockTags.CHORUS_VEGETATION_PLANTABLE_ON) && floor.isFaceSturdy(level, pos, facing);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return BlockUtil.createRotatedShape(2.0, 0.0, 2.0, 14.0, 10.0, 14.0, ChorusSproutsBlock.getFacing(state));
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos origin, BlockState state) {
        int i = 0;
        int max = Mth.nextInt((RandomSource)random, (int)1, (int)3);
        int range = Mth.nextInt((RandomSource)random, (int)4, (int)8);
        for (BlockPos pos : BlockPos.randomInCube((RandomSource)random, (int)8, (BlockPos)origin, (int)range)) {
            if (i >= max) break;
            if (!level.isEmptyBlock(pos) || !state.canSurvive((LevelReader)level, pos)) continue;
            level.setBlock(pos, state, 2);
            ++i;
        }
    }
}

