/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.AbstractGrowthBlock;
import net.bunten.enderscape.block.AbstractOvergrowthBlock;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CorruptOvergrowthBlock
extends AbstractOvergrowthBlock {
    public static final MapCodec<CorruptOvergrowthBlock> CODEC = CorruptOvergrowthBlock.simpleCodec(CorruptOvergrowthBlock::new);

    public CorruptOvergrowthBlock(BlockBehaviour.Properties settings) {
        super(false, EnderscapeBlocks.MIRESTONE.get(), EnderscapeBlocks.CORRUPT_PATH_BLOCK.get(), EnderscapeBlockSounds.CORRUPT_OVERGROWTH_FLATTEN, DirectionProperties.create().all(), settings);
    }

    protected MapCodec<CorruptOvergrowthBlock> codec() {
        return CODEC;
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos origin, BlockState state) {
        super.performBonemeal(level, random, origin, state);
        int i = 0;
        int max = Mth.nextInt((RandomSource)random, (int)1, (int)2);
        int range = Mth.nextInt((RandomSource)random, (int)4, (int)8);
        for (BlockPos pos : BlockPos.randomInCube((RandomSource)random, (int)5, (BlockPos)origin, (int)range)) {
            if (i >= max) break;
            BlockState plant = EnderscapeBlocks.CORRUPT_OVERGROWTH_BONEMEAL_PROVIDER.get().getState(random, pos);
            if (!level.isEmptyBlock(pos) || !plant.canSurvive((LevelReader)level, pos)) continue;
            level.setBlock(pos, plant, 2);
            ++i;
        }
        AbstractGrowthBlock.generatePatch(level, random, origin, (BlockState)EnderscapeBlocks.CORRUPT_GROWTH.get().defaultBlockState().setValue((Property)StateProperties.FACING, (Comparable)((Direction)state.getValue((Property)StateProperties.FACING))), Mth.nextInt((RandomSource)random, (int)3, (int)10), 0, Mth.nextInt((RandomSource)random, (int)2, (int)4));
    }
}

