/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.block.properties.StateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class DirectionalPlantBlock
extends BushBlock {
    public static final EnumProperty<Direction> FACING = StateProperties.FACING;
    public final DirectionProperties directionProperties;

    public DirectionalPlantBlock(DirectionProperties directionProperties, BlockBehaviour.Properties properties) {
        super(properties);
        this.directionProperties = directionProperties;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.UP));
    }

    public static Direction getFacing(BlockState state) {
        return (Direction)state.getValue(FACING);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public abstract boolean canPlantOn(BlockState var1, BlockState var2, BlockGetter var3, BlockPos var4, Direction var5);

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = DirectionalPlantBlock.getFacing(state);
        BlockPos offset = pos.relative(facing.getOpposite());
        BlockState floor = level.getBlockState(offset);
        return this.canPlantOn(state, floor, (BlockGetter)level, offset, facing);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        for (Direction dir : context.getNearestLookingDirections()) {
            BlockState state = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)dir.getOpposite());
            if (!this.directionProperties.supports(dir.getOpposite()) || !state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return state;
        }
        return null;
    }
}

