/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DryEndGrowthBlock
extends DirectionalPlantBlock
implements BonemealableBlock {
    public static final MapCodec<DryEndGrowthBlock> CODEC = DryEndGrowthBlock.simpleCodec(DryEndGrowthBlock::new);

    public DryEndGrowthBlock(BlockBehaviour.Properties settings) {
        super(DirectionProperties.create().up(), settings);
    }

    public MapCodec<DryEndGrowthBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean canPlantOn(BlockState state, BlockState floor, BlockGetter level, BlockPos pos, Direction facing) {
        return floor.is(EnderscapeBlockTags.DRY_END_GROWTH_PLANTABLE_ON) && floor.isFaceSturdy(level, pos, facing);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return BlockUtil.createRotatedShape(1.0, 0.0, 1.0, 14.0, 13.0, 14.0, DryEndGrowthBlock.getFacing(state));
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos origin, BlockState state) {
        int i = 0;
        int max = Mth.nextInt((RandomSource)random, (int)1, (int)3);
        int range = Mth.nextInt((RandomSource)random, (int)4, (int)8);
        for (BlockPos pos : BlockPos.randomInCube((RandomSource)random, (int)8, (BlockPos)origin, (int)range)) {
            if (i >= max) break;
            if (!level.isEmptyBlock(pos) || !state.canSurvive((LevelReader)level, pos)) continue;
            level.setBlock(pos, state, 2);
            ++i;
        }
    }
}

