/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.AbstractVineBlock;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class FlangerBerryVine
extends AbstractVineBlock
implements BonemealableBlock {
    public static final MapCodec<FlangerBerryVine> CODEC = FlangerBerryVine.simpleCodec(FlangerBerryVine::new);

    public FlangerBerryVine(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<FlangerBerryVine> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ATTACHED, AGE});
    }

    @Override
    public TagKey<Block> getPreferredBlocks() {
        return EnderscapeBlockTags.FLANGER_BERRY_VINE_PLANTABLE_ON;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        BlockState down = world.getBlockState(pos.below());
        return state.canSurvive((LevelReader)world, pos) && down.is(EnderscapeBlockTags.FLANGER_BERRY_VINE_SUPPORTS) ? this.state(state, true, FlangerBerryVine.getAge(state)) : super.updateShape(state, direction, state2, world, pos, pos2);
    }

    @Override
    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.AIR && !this.hasCollision || super.isPathfindable(state, type);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextInt(12) == 0 && this.isBonemealSuccess((Level)world, random, pos, state)) {
            this.performBonemeal(world, random, pos, state);
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos = FlangerBerryVine.isBody(state) ? pos.below() : pos;
        while (pos.getY() >= world.getMinBuildHeight()) {
            if (world.getBlockState(pos).is((Block)this) && world.getBlockState(pos.below()).isAir()) {
                return true;
            }
            pos = pos.below();
        }
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos = FlangerBerryVine.isBody(state) ? pos.below() : pos;
        while (pos.getY() > world.getMinBuildHeight()) {
            BlockState state2 = world.getBlockState(pos);
            if (state2.is((Block)this)) {
                BlockState down = world.getBlockState(pos.below());
                if ((Integer)state2.getValue((Property)AGE) == 15) {
                    if (down.isAir()) {
                        world.setBlockAndUpdate(pos, this.state(state, true, 15));
                        BlockState cycleStage = EnderscapeBlocks.FLANGER_BERRY_FLOWER.get().defaultBlockState();
                        world.setBlock(pos.below(), cycleStage, 3);
                        SoundType group = cycleStage.getSoundType();
                        world.playSound(null, pos, group.getPlaceSound(), SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 2.0f, group.getPitch() * 0.8f);
                        break;
                    }
                } else if (down.isAir()) {
                    this.growVine(world, random, pos, state, 1.0f);
                    break;
                }
            }
            pos = pos.below();
        }
    }
}

